/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import locus.api.objects.GeoData;
import locus.api.objects.extra.Location;
import locus.api.objects.extra.Point;
import locus.api.objects.extra.TrackStats;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;

public class Track
extends GeoData {
    private static final String TAG = "Track";
    List<Location> points;
    List<Integer> breaks;
    List<Point> waypoints;
    private boolean mUseFolderStyle;
    private int mActivityType;
    private TrackStats mStats;

    public Track() {
        this.id = -1L;
        this.name = "";
        this.points = new ArrayList<Location>();
        this.breaks = new ArrayList<Integer>();
        this.waypoints = new ArrayList<Point>();
        this.extraData = null;
        this.styleNormal = null;
        this.styleHighlight = null;
        this.mUseFolderStyle = true;
        this.timeCreated = System.currentTimeMillis();
        this.mStats = new TrackStats();
        this.setReadWriteMode(GeoData.ReadWriteMode.READ_WRITE);
        this.mActivityType = 0;
    }

    public Location getPoint(int index) {
        return this.points.get(index);
    }

    public int getPointsCount() {
        return this.points.size();
    }

    public List<Location> getPoints() {
        return this.points;
    }

    public boolean setPoints(List<Location> points) {
        if (points == null) {
            Logger.logW(TAG, "setPoints(), cannot be null!");
            return false;
        }
        this.points = points;
        return true;
    }

    public List<Integer> getBreaks() {
        return this.breaks;
    }

    public byte[] getBreaksData() {
        try {
            DataWriterBigEndian dw = new DataWriterBigEndian();
            for (int i = 0; i < this.breaks.size(); ++i) {
                dw.writeInt(this.breaks.get(i));
            }
            return dw.toByteArray();
        }
        catch (Exception e) {
            Logger.logE(TAG, "getBreaksData()", e);
            return new byte[0];
        }
    }

    public void setBreaksData(byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        try {
            DataReaderBigEndian dr = new DataReaderBigEndian(data);
            this.breaks.clear();
            while (dr.available() > 0) {
                this.breaks.add(dr.readInt());
            }
        }
        catch (Exception e) {
            Logger.logE(TAG, "setBreaksData()", e);
            this.breaks.clear();
        }
    }

    public Point getWaypoint(int index) {
        return this.waypoints.get(index);
    }

    public List<Point> getWaypoints() {
        return this.waypoints;
    }

    public boolean setWaypoints(List<Point> wpts) {
        if (wpts == null) {
            Logger.logW(TAG, "setWaypoints(), cannot be null!");
            return false;
        }
        this.waypoints = wpts;
        return true;
    }

    public boolean isUseFolderStyle() {
        return this.mUseFolderStyle;
    }

    public void setUseFolderStyle(boolean useFolderStyle) {
        this.mUseFolderStyle = useFolderStyle;
    }

    public int getActivityType() {
        return this.mActivityType;
    }

    public void setActivityType(int activityType) {
        this.mActivityType = activityType;
    }

    public TrackStats getStats() {
        return this.mStats;
    }

    public void setStats(TrackStats stats) {
        if (stats == null) {
            throw new NullPointerException("setTrackStats(), parameter cannot be null");
        }
        this.mStats = stats;
    }

    public void setStats(byte[] data) {
        try {
            TrackStats stats = new TrackStats();
            stats.read(data);
            this.setStats(stats);
        }
        catch (Exception e) {
            Logger.logE(TAG, "setStats(" + Arrays.toString(data) + ")", e);
            this.setStats(new TrackStats());
        }
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    public void readObject(int version, DataReaderBigEndian dr) throws IOException {
        this.id = dr.readLong();
        this.name = dr.readString();
        this.points = dr.readListStorable(Location.class);
        int breaksSize = dr.readInt();
        if (breaksSize > 0) {
            this.setBreaksData(dr.readBytes(breaksSize));
        }
        this.waypoints = dr.readListStorable(Point.class);
        this.readExtraData(dr);
        this.readStyles(dr);
        this.mStats = new TrackStats();
        this.mStats.setNumOfPoints(dr.readInt());
        this.mStats.setStartTime(dr.readLong());
        this.mStats.setStopTime(dr.readLong());
        this.mStats.setTotalLength(dr.readFloat());
        this.mStats.setTotalLengthMove(dr.readFloat());
        this.mStats.setTotalTime(dr.readLong());
        this.mStats.setTotalTimeMove(dr.readLong());
        this.mStats.setSpeedMax(dr.readFloat());
        this.mStats.setAltitudeMax(dr.readFloat());
        this.mStats.setAltitudeMin(dr.readFloat());
        this.mStats.setEleNeutralDistance(dr.readFloat());
        this.mStats.setEleNeutralHeight(dr.readFloat());
        this.mStats.setElePositiveDistance(dr.readFloat());
        this.mStats.setElePositiveHeight(dr.readFloat());
        this.mStats.setEleNegativeDistance(dr.readFloat());
        this.mStats.setEleNegativeHeight(dr.readFloat());
        this.mStats.setEleTotalAbsDistance(dr.readFloat());
        this.mStats.setEleTotalAbsHeight(dr.readFloat());
        if (version >= 1) {
            this.mUseFolderStyle = dr.readBoolean();
        }
        if (version >= 2) {
            this.timeCreated = dr.readLong();
        }
        if (version >= 3) {
            this.mStats = new TrackStats();
            this.mStats.read(dr);
        }
        if (version >= 4) {
            this.setReadWriteMode(GeoData.ReadWriteMode.values()[dr.readInt()]);
        }
        if (version >= 5) {
            this.mActivityType = dr.readInt();
        }
    }

    @Override
    public void writeObject(DataWriterBigEndian dw) throws IOException {
        dw.writeLong(this.id);
        dw.writeString(this.name);
        dw.writeListStorable(this.points);
        byte[] breaksData = this.getBreaksData();
        dw.writeInt(breaksData.length);
        if (breaksData.length > 0) {
            dw.write(breaksData);
        }
        dw.writeListStorable(this.waypoints);
        this.writeExtraData(dw);
        this.writeStyles(dw);
        dw.writeInt(0);
        dw.writeLong(0L);
        dw.writeLong(0L);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeLong(0L);
        dw.writeLong(0L);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeBoolean(this.mUseFolderStyle);
        dw.writeLong(this.timeCreated);
        dw.writeStorable(this.mStats);
        dw.writeInt(this.getReadWriteMode().ordinal());
        dw.writeInt(this.mActivityType);
    }
}

