/*
 * Decompiled with CFR 0.152.
 */
package locus.api.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import locus.api.objects.Storable;
import locus.api.utils.Logger;

public class DataReaderBigEndian {
    private static final String TAG = "DataReaderBigEndian";
    private int mPosition;
    private byte[] mBuffer;

    public DataReaderBigEndian(byte[] data) throws IOException {
        if (data == null) {
            throw new IOException("Invalid parameter");
        }
        this.mPosition = 0;
        this.mBuffer = data;
    }

    public long length() {
        return this.mBuffer.length;
    }

    public int available() {
        return this.mBuffer.length - this.mPosition;
    }

    public void seek(int pos) {
        this.mPosition = pos;
    }

    public byte readByte() {
        this.checkPosition(1);
        return this.mBuffer[this.mPosition - 1];
    }

    public byte[] readBytes(int count) {
        this.checkPosition(count);
        byte[] newData = new byte[count];
        System.arraycopy(this.mBuffer, this.mPosition - count, newData, 0, count);
        return newData;
    }

    public void readBytes(byte[] data) {
        this.checkPosition(data.length);
        System.arraycopy(this.mBuffer, this.mPosition - data.length, data, 0, data.length);
    }

    public boolean readBoolean() {
        this.checkPosition(1);
        return this.mBuffer[this.mPosition - 1] != 0;
    }

    public short readShort() {
        this.checkPosition(2);
        return (short)((this.mBuffer[this.mPosition - 2] & 0xFF) << 8 | this.mBuffer[this.mPosition - 1] & 0xFF);
    }

    public int readInt() {
        this.checkPosition(4);
        return this.mBuffer[this.mPosition - 4] << 24 | (this.mBuffer[this.mPosition - 3] & 0xFF) << 16 | (this.mBuffer[this.mPosition - 2] & 0xFF) << 8 | this.mBuffer[this.mPosition - 1] & 0xFF;
    }

    public long readLong() {
        this.checkPosition(8);
        return ((long)this.mBuffer[this.mPosition - 8] & 0xFFL) << 56 | ((long)this.mBuffer[this.mPosition - 7] & 0xFFL) << 48 | ((long)this.mBuffer[this.mPosition - 6] & 0xFFL) << 40 | ((long)this.mBuffer[this.mPosition - 5] & 0xFFL) << 32 | ((long)this.mBuffer[this.mPosition - 4] & 0xFFL) << 24 | ((long)this.mBuffer[this.mPosition - 3] & 0xFFL) << 16 | ((long)this.mBuffer[this.mPosition - 2] & 0xFFL) << 8 | (long)this.mBuffer[this.mPosition - 1] & 0xFFL;
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readString() throws IOException {
        int textLength = this.readInt();
        if (textLength == 0) {
            return "";
        }
        this.checkPosition(textLength);
        return new String(this.mBuffer, this.mPosition - textLength, textLength, "UTF-8");
    }

    @Deprecated
    public String readStringDis() throws IOException {
        short textLength = this.readShort();
        if (textLength == 0) {
            return "";
        }
        this.checkPosition(textLength);
        return new String(this.mBuffer, this.mPosition - textLength, (int)textLength, "UTF-8");
    }

    public <E extends Storable> E readStorable(Class<E> claz) throws InstantiationException, IllegalAccessException, IOException {
        return Storable.read(claz, this);
    }

    public List<String> readListString() throws IOException {
        ArrayList<String> objs = new ArrayList<String>();
        int count = this.readInt();
        if (count == 0) {
            return objs;
        }
        for (int i = 0; i < count; ++i) {
            objs.add(this.readString());
        }
        return objs;
    }

    public <E extends Storable> List<E> readListStorable(Class<E> claz) throws IOException {
        ArrayList<Storable> objs = new ArrayList<Storable>();
        int count = this.readInt();
        if (count == 0) {
            return objs;
        }
        for (int i = 0; i < count; ++i) {
            try {
                Storable item = (Storable)claz.newInstance();
                item.read(this);
                objs.add(item);
                continue;
            }
            catch (InstantiationException e) {
                Logger.logE(TAG, "readList(" + claz + ")", e);
                continue;
            }
            catch (IllegalAccessException e) {
                Logger.logE(TAG, "readList(" + claz + ")", e);
            }
        }
        return objs;
    }

    private void checkPosition(int increment) {
        this.mPosition += increment;
        if (this.mPosition > this.mBuffer.length) {
            throw new ArrayIndexOutOfBoundsException("Invalid position for data load. Current:" + this.mPosition + ", length:" + this.mBuffer.length + ", increment:" + increment);
        }
    }
}

