/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.internal.ClassUtils;
import com.atlassian.event.internal.ListenerInvokerWithClassHierarchyAndRegisterOrder;
import com.atlassian.event.internal.ListenerInvokerWithRegisterOrder;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.plugin.eventlistener.descriptors.EventListenerModuleDescriptor;
import com.atlassian.plugin.scope.ScopeManager;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EventPublisherUtils {
    public static Set<ListenerInvokerWithClassHierarchyAndRegisterOrder> getInvokersWithClassHierarchyOrder(Object event, Function<Class<?>, Collection<ListenerInvokerWithRegisterOrder>> eventToListeners) {
        LinkedHashSet<ListenerInvokerWithClassHierarchyAndRegisterOrder> invokers = new LinkedHashSet<ListenerInvokerWithClassHierarchyAndRegisterOrder>();
        AtomicInteger classHierarchyOrder = new AtomicInteger();
        for (Class<?> eventClass : ClassUtils.findAllTypes(Preconditions.checkNotNull((Object)event).getClass())) {
            invokers.addAll(eventToListeners.apply(eventClass).stream().map(invoker -> new ListenerInvokerWithClassHierarchyAndRegisterOrder((ListenerInvokerWithRegisterOrder)invoker, classHierarchyOrder.get())).collect(Collectors.toList()));
            classHierarchyOrder.incrementAndGet();
        }
        return invokers;
    }

    static Set<ListenerInvoker> sortInvokers(ScopeManager scopeManager, Set<ListenerInvokerWithClassHierarchyAndRegisterOrder> invokers) {
        return invokers.stream().filter(i -> i.keyedListenerInvoker.getScope().map(arg_0 -> ((ScopeManager)scopeManager).isScopeActive(arg_0)).orElse(true)).sorted(Comparator.comparingInt(value -> value.getListenerInvokerWithRegisterOrder().getOrder()).thenComparingInt(value -> value.classHierarchyOrder).thenComparingInt(value -> value.getListenerInvokerWithRegisterOrder().getRegisterOrder())).map(ListenerInvokerWithClassHierarchyAndRegisterOrder::getListenerInvokerWithRegisterOrder).map(ListenerInvokerWithRegisterOrder::getInvoker).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static Object getListener(Object listener) {
        if (listener instanceof EventListenerModuleDescriptor) {
            EventListenerModuleDescriptor descriptor = (EventListenerModuleDescriptor)listener;
            return descriptor.getModule();
        }
        return listener;
    }
}

