/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.EventPublisherUtils;
import com.atlassian.event.internal.ListenerInvokerWithClassHierarchyAndRegisterOrder;
import com.atlassian.event.internal.ListenerInvokerWithRegisterOrder;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.plugin.eventlistener.descriptors.EventListenerModuleDescriptor;
import com.atlassian.plugin.scope.EverythingIsActiveScopeManager;
import com.atlassian.plugin.scope.ScopeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventPublisherImpl
implements EventPublisher {
    private static final Logger log = LoggerFactory.getLogger(EventPublisherImpl.class);
    private static final String PROPERTY_PREFIX = EventPublisherImpl.class.getName();
    private static final Optional<String> debugRegistration = Optional.ofNullable(System.getProperty(PROPERTY_PREFIX + ".debugRegistration"));
    private static final boolean debugRegistrationLocation = Boolean.getBoolean(PROPERTY_PREFIX + ".debugRegistrationLocation");
    private static final Optional<String> debugInvocation = Optional.ofNullable(System.getProperty(PROPERTY_PREFIX + ".debugInvocation"));
    private static final boolean debugInvocationLocation = Boolean.getBoolean(PROPERTY_PREFIX + ".debugInvocationLocation");
    private final EventDispatcher eventDispatcher;
    private final List<ListenerHandler> listenerHandlers;
    private final ScopeManager scopeManager;
    private final Multimap<Class<?>, ListenerInvokerWithRegisterOrder> listenerInvokers;

    public EventPublisherImpl(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this(eventDispatcher, listenerHandlersConfiguration, (ScopeManager)new EverythingIsActiveScopeManager());
    }

    public EventPublisherImpl(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration, ScopeManager scopeManager) {
        this.eventDispatcher = (EventDispatcher)Preconditions.checkNotNull((Object)eventDispatcher);
        this.listenerHandlers = (List)Preconditions.checkNotNull(((ListenerHandlersConfiguration)Preconditions.checkNotNull((Object)listenerHandlersConfiguration)).getListenerHandlers());
        this.listenerInvokers = this.newMultimap();
        this.scopeManager = (ScopeManager)Preconditions.checkNotNull((Object)scopeManager);
    }

    @Override
    public void publish(@Nonnull Object event) {
        this.invokeListeners(this.findListenerInvokersForEvent(Preconditions.checkNotNull((Object)event)), event);
    }

    @Override
    public void register(@Nonnull Object listener) {
        this.registerListener(listener);
    }

    @Override
    public void unregister(@Nonnull Object listener) {
        this.unregisterListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAll() {
        Multimap<Class<?>, ListenerInvokerWithRegisterOrder> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.listenerInvokers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListener(Object listener) {
        Multimap<Class<?>, ListenerInvokerWithRegisterOrder> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.listenerInvokers.entries().removeIf(entry -> ((ListenerInvokerWithRegisterOrder)entry.getValue()).isFor(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(Object listener) {
        Optional parentScope;
        if (listener instanceof EventListenerModuleDescriptor) {
            EventListenerModuleDescriptor descriptor = (EventListenerModuleDescriptor)listener;
            parentScope = descriptor.getScopeKey();
        } else {
            parentScope = Optional.empty();
        }
        Object listenerImpl = EventPublisherUtils.getListener(listener);
        Multimap<Class<?>, ListenerInvokerWithRegisterOrder> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.unregisterListener(listener);
            ArrayList invokers = Lists.newArrayList();
            for (ListenerHandler listenerHandler : this.listenerHandlers) {
                invokers.addAll(listenerHandler.getInvokers(listenerImpl));
            }
            if (invokers.isEmpty()) {
                throw new IllegalArgumentException("No listener invokers were found for listener <" + listenerImpl + ">");
            }
            this.registerListenerInvokers(listener, parentScope, invokers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ListenerInvoker> findListenerInvokersForEvent(Object event) {
        Set<ListenerInvokerWithClassHierarchyAndRegisterOrder> invokers;
        Multimap<Class<?>, ListenerInvokerWithRegisterOrder> multimap = this.listenerInvokers;
        synchronized (multimap) {
            invokers = EventPublisherUtils.getInvokersWithClassHierarchyOrder(event, arg_0 -> this.listenerInvokers.get(arg_0));
        }
        return EventPublisherUtils.sortInvokers(this.scopeManager, invokers);
    }

    private void invokeListeners(Collection<ListenerInvoker> listenerInvokers, Object event) {
        String eventClass = event.getClass().getName();
        boolean debugThisInvocation = debugInvocation.map(eventClass::startsWith).orElse(false);
        for (ListenerInvoker invoker : listenerInvokers) {
            if (debugThisInvocation) {
                log.warn("Listener invoked event with class '{}' -> invoker {}", (Object)eventClass, (Object)invoker);
                if (debugInvocationLocation) {
                    log.warn("Invoked from", (Throwable)new Exception());
                }
            }
            try {
                this.eventDispatcher.dispatch(invoker, event);
            }
            catch (Exception e) {
                log.error("There was an exception thrown trying to dispatch event '{}' from the invoker '{}'.", new Object[]{event, invoker, e});
            }
        }
    }

    private void registerListenerInvokers(Object listener, Optional<String> parentScope, List<? extends ListenerInvoker> invokers) {
        for (ListenerInvoker listenerInvoker : invokers) {
            this.registerListenerInvoker(listener, parentScope, listenerInvoker);
        }
    }

    private void registerListenerInvoker(Object listener, Optional<String> parentScope, ListenerInvoker invoker) {
        if (invoker.getSupportedEventTypes().isEmpty()) {
            this.putEventListenerInvoker(Object.class, listener, parentScope, invoker);
        }
        for (Class<?> eventClass : invoker.getSupportedEventTypes()) {
            this.putEventListenerInvoker(eventClass, listener, parentScope, invoker);
        }
    }

    private void putEventListenerInvoker(Class<?> eventClass, Object listener, Optional<String> parentScope, ListenerInvoker invoker) {
        debugRegistration.ifPresent(classPrefix -> {
            if (eventClass.getName().startsWith((String)classPrefix)) {
                log.warn("Listener registered event '{}' -> invoker {}", (Object)eventClass, (Object)invoker);
                if (debugRegistrationLocation) {
                    log.warn("Registered from", (Throwable)new Exception());
                }
            }
        });
        String listenerKey = ObjectUtils.identityToString((Object)listener);
        log.debug("Registering {} with scope {} and order {}", new Object[]{listenerKey, parentScope, invoker.getOrder()});
        if (parentScope.isPresent() && invoker.getScope().isPresent() && !parentScope.equals(invoker.getScope())) {
            throw new IllegalArgumentException("Listener <" + listenerKey + "> tries to override parent scope <" + parentScope.get() + "> with <" + invoker.getScope() + ">");
        }
        Optional<String> invokerScope = parentScope.isPresent() ? parentScope : invoker.getScope();
        int order = invoker.getOrder();
        this.listenerInvokers.put(eventClass, (Object)new ListenerInvokerWithRegisterOrder(listener, invoker, invokerScope));
    }

    private Multimap<Class<?>, ListenerInvokerWithRegisterOrder> newMultimap() {
        return Multimaps.synchronizedMultimap((Multimap)Multimaps.newMultimap(new HashMap(), HashSet::new));
    }
}

