/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClientFactory;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AtlassianHttpClientDecorator;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousHttpClientFactory {
    public DisposableHttpClient createClient(URI serverUri, AuthenticationHandler authenticationHandler) {
        HttpClientOptions options = new HttpClientOptions();
        final DefaultHttpClientFactory defaultHttpClientFactory = new DefaultHttpClientFactory((EventPublisher)new NoOpEventPublisher(), (ApplicationProperties)new RestClientApplicationProperties(serverUri), new ThreadLocalContextManager(){

            public Object getThreadLocalContext() {
                return null;
            }

            public void setThreadLocalContext(Object context) {
            }

            public void clearThreadLocalContext() {
            }
        });
        final HttpClient httpClient = defaultHttpClientFactory.create(options);
        return new AtlassianHttpClientDecorator(httpClient, authenticationHandler){

            @Override
            public void destroy() throws Exception {
                defaultHttpClientFactory.dispose(httpClient);
            }
        };
    }

    public DisposableHttpClient createClient(HttpClient client) {
        return new AtlassianHttpClientDecorator(client, null){

            @Override
            public void destroy() throws Exception {
            }
        };
    }

    private static final class MavenUtils {
        private static final Logger logger = LoggerFactory.getLogger(MavenUtils.class);
        private static final String UNKNOWN_VERSION = "unknown";

        private MavenUtils() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String getVersion(String groupId, String artifactId) {
            Properties props = new Properties();
            InputStream resourceAsStream = null;
            try {
                resourceAsStream = MavenUtils.class.getResourceAsStream(String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId));
                props.load(resourceAsStream);
                String string = props.getProperty("version", UNKNOWN_VERSION);
                return string;
            }
            catch (Exception e) {
                logger.debug("Could not find version for maven artifact {}:{}", (Object)groupId, (Object)artifactId);
                logger.debug("Got the following exception", (Throwable)e);
                String string = UNKNOWN_VERSION;
                return string;
            }
            finally {
                if (resourceAsStream != null) {
                    try {
                        resourceAsStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class RestClientApplicationProperties
    implements ApplicationProperties {
        private final String baseUrl;

        private RestClientApplicationProperties(URI jiraURI) {
            this.baseUrl = jiraURI.getPath();
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Nonnull
        public String getBaseUrl(UrlMode urlMode) {
            return this.baseUrl;
        }

        @Nonnull
        public String getDisplayName() {
            return "Atlassian JIRA Rest Java Client";
        }

        @Nonnull
        public String getPlatformId() {
            return "jira";
        }

        @Nonnull
        public String getVersion() {
            return MavenUtils.getVersion("com.atlassian.jira", "jira-rest-java-com.atlassian.jira.rest.client");
        }

        @Nonnull
        public Date getBuildDate() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public String getBuildNumber() {
            return String.valueOf(0);
        }

        public File getHomeDirectory() {
            return new File(".");
        }

        public String getPropertyValue(String s) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private static class NoOpEventPublisher
    implements EventPublisher {
        private NoOpEventPublisher() {
        }

        public void publish(Object o) {
        }

        public void register(Object o) {
        }

        public void unregister(Object o) {
        }

        public void unregisterAll() {
        }
    }
}

