/*
 * Decompiled with CFR 0.152.
 */
package com.baoyz.pg;

import android.os.Parcel;
import com.baoyz.pg.ParcelIgnore;
import com.baoyz.pg.ParcelUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class PGUtils {
    public static void write(Object obj, Parcel dest) {
        PGUtils.write(obj, obj.getClass().getSuperclass(), dest);
    }

    private static void write(Object obj, Class<?> clazz, Parcel dest) {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            PGUtils.log("write = " + field.getName());
            PGUtils.writeValue(dest, field, obj);
        }
        if (clazz.getSuperclass() != null && clazz != Object.class) {
            PGUtils.write(obj, clazz.getSuperclass(), dest);
        }
    }

    private static void writeValue(Parcel dest, Field field, Object target) {
        try {
            if (!PGUtils.checkSerializable(field)) {
                return;
            }
            field.setAccessible(true);
            if (field.getType().equals(Integer.TYPE)) {
                dest.writeInt(field.getInt(target));
            } else if (field.getType().equals(Double.TYPE)) {
                dest.writeDouble(field.getDouble(target));
            } else if (field.getType().equals(Float.TYPE)) {
                dest.writeFloat(field.getFloat(target));
            } else if (field.getType().equals(Long.TYPE)) {
                dest.writeLong(field.getLong(target));
            } else if (field.getType().equals(Boolean.TYPE)) {
                dest.writeInt(field.getBoolean(target) ? 1 : 0);
            } else if (field.getType().equals(Character.TYPE)) {
                dest.writeInt((int)field.getChar(target));
            } else if (field.getType().equals(Byte.TYPE)) {
                dest.writeByte(field.getByte(target));
            } else if (field.getType().equals(Short.TYPE)) {
                dest.writeInt((int)field.getShort(target));
            } else {
                Object value = field.get(target);
                ParcelUtil.writeValue(dest, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean checkSerializable(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && !field.isAnnotationPresent(ParcelIgnore.class);
    }

    public static void read(Object obj, Parcel source) {
        PGUtils.read(obj, obj.getClass().getSuperclass(), source);
    }

    private static void read(Object obj, Class<?> clazz, Parcel source) {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            PGUtils.log("read = " + field.getName());
            PGUtils.readValue(source, field, obj);
        }
        if (clazz.getSuperclass() != null && clazz != Object.class) {
            PGUtils.read(obj, clazz.getSuperclass(), source);
        }
    }

    private static void readValue(Parcel source, Field field, Object target) {
        try {
            if (!PGUtils.checkSerializable(field)) {
                return;
            }
            field.setAccessible(true);
            if (field.getType().equals(Integer.TYPE)) {
                field.setInt(target, source.readInt());
            } else if (field.getType().equals(Double.TYPE)) {
                field.setDouble(target, source.readDouble());
            } else if (field.getType().equals(Float.TYPE)) {
                field.setFloat(target, source.readFloat());
            } else if (field.getType().equals(Long.TYPE)) {
                field.setLong(target, source.readLong());
            } else if (field.getType().equals(Boolean.TYPE)) {
                field.setBoolean(target, source.readInt() != 0);
            } else if (field.getType().equals(Character.TYPE)) {
                field.setChar(target, (char)source.readInt());
            } else if (field.getType().equals(Byte.TYPE)) {
                field.setByte(target, source.readByte());
            } else if (field.getType().equals(Short.TYPE)) {
                field.setShort(target, (short)source.readInt());
            } else {
                field.set(target, source.readValue(target.getClass().getClassLoader()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clone(Object source, Object dest) {
        PGUtils.clone(source.getClass(), source, dest);
    }

    private static void clone(Class<?> clazz, Object source, Object dest) {
        Field[] declaredFields = clazz.getDeclaredFields();
        try {
            for (Field field : declaredFields) {
                field.setAccessible(true);
                if (Modifier.isFinal(field.getModifiers())) continue;
                field.set(dest, field.get(source));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            PGUtils.clone(clazz.getSuperclass(), source, dest);
        }
    }

    private static void log(String log) {
    }
}

