/*
 * Decompiled with CFR 0.152.
 */
package com.baoyz.pg;

import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.baoyz.pg.PG;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParcelUtil {
    private static final int VAL_NULL = -1;
    private static final int VAL_STRING = 0;
    private static final int VAL_INTEGER = 1;
    private static final int VAL_MAP = 2;
    private static final int VAL_BUNDLE = 3;
    private static final int VAL_PARCELABLE = 4;
    private static final int VAL_SHORT = 5;
    private static final int VAL_LONG = 6;
    private static final int VAL_FLOAT = 7;
    private static final int VAL_DOUBLE = 8;
    private static final int VAL_BOOLEAN = 9;
    private static final int VAL_CHARSEQUENCE = 10;
    private static final int VAL_LIST = 11;
    private static final int VAL_SPARSEARRAY = 12;
    private static final int VAL_BYTEARRAY = 13;
    private static final int VAL_STRINGARRAY = 14;
    private static final int VAL_IBINDER = 15;
    private static final int VAL_PARCELABLEARRAY = 16;
    private static final int VAL_OBJECTARRAY = 17;
    private static final int VAL_INTARRAY = 18;
    private static final int VAL_LONGARRAY = 19;
    private static final int VAL_BYTE = 20;
    private static final int VAL_SERIALIZABLE = 21;
    private static final int VAL_SPARSEBOOLEANARRAY = 22;
    private static final int VAL_BOOLEANARRAY = 23;
    private static final int VAL_CHARSEQUENCEARRAY = 24;

    public static void writeValue(Parcel dest, Object v) {
        try {
            ParcelUtil.writeValueInternal(dest, v);
        }
        catch (Exception e) {
            ParcelUtil.writeValueInternal(dest, PG.convert(v));
        }
    }

    private static void writeValueInternal(Parcel dest, Object v) {
        if (v == null) {
            dest.writeInt(-1);
        } else if (v instanceof String) {
            dest.writeInt(0);
            dest.writeString((String)v);
        } else if (v instanceof Integer) {
            dest.writeInt(1);
            dest.writeInt(((Integer)v).intValue());
        } else if (v instanceof Map) {
            dest.writeInt(2);
            ParcelUtil.writeMap(dest, (Map)v);
        } else if (v instanceof Bundle) {
            dest.writeInt(3);
            dest.writeBundle((Bundle)v);
        } else if (v instanceof Parcelable) {
            dest.writeInt(4);
            dest.writeParcelable((Parcelable)v, 0);
        } else if (v instanceof Short) {
            dest.writeInt(5);
            dest.writeInt(((Short)v).intValue());
        } else if (v instanceof Long) {
            dest.writeInt(6);
            dest.writeLong(((Long)v).longValue());
        } else if (v instanceof Float) {
            dest.writeInt(7);
            dest.writeFloat(((Float)v).floatValue());
        } else if (v instanceof Double) {
            dest.writeInt(8);
            dest.writeDouble(((Double)v).doubleValue());
        } else if (v instanceof Boolean) {
            dest.writeInt(9);
            dest.writeInt((Boolean)v != false ? 1 : 0);
        } else if (v instanceof CharSequence) {
            dest.writeInt(10);
            TextUtils.writeToParcel((CharSequence)((CharSequence)v), (Parcel)dest, (int)0);
        } else if (v instanceof List) {
            dest.writeInt(11);
            ParcelUtil.writeList(dest, (List)v);
        } else if (v instanceof SparseArray) {
            dest.writeInt(12);
            ParcelUtil.writeSparseArray(dest, (SparseArray<Object>)((SparseArray)v));
        } else if (v instanceof boolean[]) {
            dest.writeInt(23);
            dest.writeBooleanArray((boolean[])v);
        } else if (v instanceof byte[]) {
            dest.writeInt(13);
            dest.writeByteArray((byte[])v);
        } else if (v instanceof String[]) {
            dest.writeInt(14);
            dest.writeStringArray((String[])v);
        } else if (v instanceof CharSequence[]) {
            dest.writeInt(24);
            CharSequence[] val = (CharSequence[])v;
            int N = val.length;
            dest.writeInt(N);
            for (int i = 0; i < N; ++i) {
                TextUtils.writeToParcel((CharSequence)val[i], (Parcel)dest, (int)0);
            }
        } else if (v instanceof IBinder) {
            dest.writeInt(15);
            dest.writeStrongBinder((IBinder)v);
        } else if (v instanceof Parcelable[]) {
            dest.writeInt(16);
            dest.writeParcelableArray((Parcelable[])v, 0);
        } else if (v instanceof Object[]) {
            dest.writeInt(17);
            ParcelUtil.writeArray(dest, (Object[])v);
        } else if (v instanceof int[]) {
            dest.writeInt(18);
            dest.writeIntArray((int[])v);
        } else if (v instanceof long[]) {
            dest.writeInt(19);
            dest.writeLongArray((long[])v);
        } else if (v instanceof Byte) {
            dest.writeInt(20);
            dest.writeInt((int)((Byte)v).byteValue());
        } else if (v instanceof Serializable) {
            dest.writeInt(21);
            dest.writeSerializable((Serializable)v);
        } else {
            throw new RuntimeException("Parcel: unable to marshal value " + v);
        }
    }

    private static void writeMap(Parcel dest, Map<Object, Object> val) {
        if (val == null) {
            dest.writeInt(-1);
            return;
        }
        Set<Map.Entry<Object, Object>> entries = val.entrySet();
        dest.writeInt(entries.size());
        for (Map.Entry<Object, Object> e : entries) {
            ParcelUtil.writeValue(dest, e.getKey());
            ParcelUtil.writeValue(dest, e.getValue());
        }
    }

    private static void writeList(Parcel dest, List val) {
        if (val == null) {
            dest.writeInt(-1);
            return;
        }
        int N = val.size();
        dest.writeInt(N);
        for (int i = 0; i < N; ++i) {
            ParcelUtil.writeValue(dest, val.get(i));
        }
    }

    private static void writeSparseArray(Parcel dest, SparseArray<Object> val) {
        if (val == null) {
            dest.writeInt(-1);
            return;
        }
        int N = val.size();
        dest.writeInt(N);
        for (int i = 0; i < N; ++i) {
            dest.writeInt(val.keyAt(i));
            ParcelUtil.writeValue(dest, val.valueAt(i));
        }
    }

    private static void writeArray(Parcel dest, Object[] val) {
        if (val == null) {
            dest.writeInt(-1);
            return;
        }
        int N = val.length;
        dest.writeInt(N);
        for (int i = 0; i < N; ++i) {
            ParcelUtil.writeValue(dest, val[i]);
        }
    }
}

