/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.brouter.common.util.matcher;

import com.bilibili.brouter.common.util.matcher.TokenMismatchException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0007\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\n\u0010\u0010\u001a\u00060\u0003j\u0002`\u0011J\u0006\u0010\u0012\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bilibili/brouter/common/util/matcher/BRouterUriLexer;", "", "input", "", "(Ljava/lang/String;)V", "end", "", "mark", "position", "isReservedChar", "", "", "match", "c", "", "nextChar", "nextText", "Lcom/bilibili/brouter/common/util/matcher/Text;", "peekChar", "reachEnd", "reset", "skipChar", "unexpectedChar", "", "s", "Companion", "brouter-runtime-common"})
public final class BRouterUriLexer {
    private int position;
    private int mark;
    private final int end;
    private final String input;
    private static final boolean[] MAP;
    public static final Companion Companion;

    public final void match(char c) {
        int n = this.position;
        this.position = n + 1;
        int p = n;
        try {
            char r = this.input.charAt(p);
            if (c != r) {
                throw (Throwable)new TokenMismatchException("Expected '" + c + "' at " + p + " but is '" + r + "'.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw (Throwable)new TokenMismatchException("Expected '" + c + "' at " + p + " but reach end.");
        }
    }

    public final boolean reachEnd() {
        return this.position >= this.end;
    }

    public final void mark() {
        this.mark = this.position;
    }

    public final void reset() {
        this.position = this.mark;
    }

    public final char nextChar() {
        int n = this.position;
        this.position = n + 1;
        return this.input.charAt(n);
    }

    public final void skipChar() {
        int n = this.position;
        this.position = n + 1;
    }

    public final char peekChar() {
        char c;
        try {
            c = this.input.charAt(this.position);
        }
        catch (IndexOutOfBoundsException e) {
            throw (Throwable)new TokenMismatchException("Expected a char at " + this.position + " but reach end.");
        }
        return c;
    }

    @NotNull
    public final String nextText() {
        char c;
        int p;
        for (p = this.position; p < this.end && !Companion.isReservedChar(c = this.input.charAt(p)); ++p) {
        }
        if (p <= this.position) {
            throw (Throwable)new TokenMismatchException("Expected normal text at " + p + " but is empty.");
        }
        int start = this.position;
        this.position = p;
        String string = this.input;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, p);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final Void unexpectedChar(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        throw (Throwable)new TokenMismatchException("Expected one of \"" + s + "\" but is '" + this.peekChar() + "' at " + this.position + '.');
    }

    public final boolean isReservedChar() {
        return Companion.isReservedChar(this.input.charAt(this.position));
    }

    public BRouterUriLexer(@NotNull String input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        this.input = input;
        this.end = this.input.length();
    }

    static {
        Companion = new Companion(null);
        boolean[] blArray = new boolean[128];
        boolean bl = false;
        boolean bl2 = false;
        boolean[] $this$apply = blArray;
        boolean bl3 = false;
        Character[] $this$forEach$iv = new Character[]{Character.valueOf('/'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf('|'), Character.valueOf('*')};
        boolean $i$f$forEach = false;
        for (Character element$iv : $this$forEach$iv) {
            char it = element$iv.charValue();
            boolean bl4 = false;
            $this$apply[it] = true;
        }
        MAP = blArray;
    }

    @JvmStatic
    public static final boolean isReservedChar(char c) {
        return Companion.isReservedChar(c);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/bilibili/brouter/common/util/matcher/BRouterUriLexer$Companion;", "", "()V", "MAP", "", "isReservedChar", "", "c", "", "brouter-runtime-common"})
    public static final class Companion {
        @JvmStatic
        public final boolean isReservedChar(char c) {
            char c2 = c;
            boolean bl = false;
            boolean bl2 = false;
            char it = c2;
            boolean bl3 = false;
            return it < '\u0080' && MAP[it];
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

