/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.brouter.common.util.matcher;

import com.bilibili.brouter.common.util.matcher.BRouterUriLexer;
import com.bilibili.brouter.common.util.matcher.ForSchemeSegmentsParser;
import com.bilibili.brouter.common.util.matcher.InvalidUriException;
import com.bilibili.brouter.common.util.matcher.NoSchemeSegmentsParser;
import com.bilibili.brouter.common.util.matcher.NormalRawSegment;
import com.bilibili.brouter.common.util.matcher.PrefixRawSegment;
import com.bilibili.brouter.common.util.matcher.RawSegment;
import com.bilibili.brouter.common.util.matcher.SegmentParts;
import com.bilibili.brouter.common.util.matcher.TokenMismatchException;
import com.bilibili.brouter.common.util.matcher.WildCardRawSegment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H$J\u0018\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00040\bj\u0002`\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/bilibili/brouter/common/util/matcher/RawSegmentsParser;", "", "()V", "defaultSchemeSegment", "Lcom/bilibili/brouter/common/util/matcher/RawSegment;", "input", "", "parse", "", "Lcom/bilibili/brouter/common/util/matcher/RawSegments;", "parseNormalSegment", "Lcom/bilibili/brouter/common/util/matcher/NormalRawSegment;", "lexer", "Lcom/bilibili/brouter/common/util/matcher/BRouterUriLexer;", "parseSegment", "parseSegmentParts", "Lcom/bilibili/brouter/common/util/matcher/SegmentParts;", "Companion", "brouter-runtime-common"})
public abstract class RawSegmentsParser {
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract RawSegment defaultSchemeSegment(@NotNull String var1);

    @NotNull
    public final List<RawSegment> parse(@NotNull String input) {
        ArrayList arrayList;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        try {
            Object object;
            Collection collection;
            BRouterUriLexer lexer = new BRouterUriLexer(input);
            ArrayList segments = new ArrayList(4);
            if (lexer.peekChar() == '/') {
                lexer.skipChar();
                collection = segments;
                object = this.defaultSchemeSegment(input);
                boolean bl = false;
                collection.add(object);
                collection = segments;
                object = this.parseSegment(lexer);
                bl = false;
                collection.add(object);
            } else {
                boolean bl;
                RawSegment s = this.parseSegment(lexer);
                if (lexer.reachEnd() || lexer.peekChar() != ':') {
                    object = segments;
                    RawSegment rawSegment = this.defaultSchemeSegment(input);
                    bl = false;
                    object.add(rawSegment);
                    object = segments;
                    boolean bl2 = false;
                    object.add(s);
                } else {
                    lexer.skipChar();
                    lexer.match('/');
                    lexer.match('/');
                    object = segments;
                    boolean bl3 = false;
                    object.add(s);
                    object = segments;
                    RawSegment rawSegment = this.parseSegment(lexer);
                    bl = false;
                    object.add(rawSegment);
                }
            }
            while (!lexer.reachEnd()) {
                lexer.match('/');
                if (lexer.reachEnd()) break;
                collection = segments;
                object = this.parseSegment(lexer);
                boolean bl = false;
                collection.add(object);
            }
            arrayList = segments;
        }
        catch (TokenMismatchException e) {
            throw (Throwable)new InvalidUriException("Error on pause " + input + '.', e);
        }
        return arrayList;
    }

    private final RawSegment parseSegment(BRouterUriLexer lexer) {
        RawSegment rawSegment;
        String prefix;
        String string = prefix = !lexer.isReservedChar() ? lexer.nextText() : null;
        if (prefix != null && lexer.reachEnd()) {
            rawSegment = new NormalRawSegment(prefix, null, null);
        } else {
            char c = lexer.peekChar();
            switch (c) {
                case '(': {
                    NormalRawSegment normalRawSegment = this.parseNormalSegment(lexer);
                    boolean bl = false;
                    boolean bl2 = false;
                    NormalRawSegment it = normalRawSegment;
                    boolean bl3 = false;
                    rawSegment = prefix == null ? it : new NormalRawSegment(prefix, null, it);
                    break;
                }
                case '{': {
                    String string2;
                    lexer.skipChar();
                    if (lexer.peekChar() == '}') {
                        lexer.skipChar();
                        string2 = null;
                    } else {
                        String string3 = lexer.nextText();
                        boolean bl = false;
                        boolean bl4 = false;
                        String it = string3;
                        boolean bl5 = false;
                        lexer.match('}');
                        string2 = string3;
                    }
                    String name = string2;
                    String suffix = lexer.reachEnd() || lexer.isReservedChar() ? null : lexer.nextText();
                    rawSegment = new WildCardRawSegment(prefix, name, suffix);
                    break;
                }
                case '*': {
                    lexer.skipChar();
                    if (lexer.reachEnd()) {
                        rawSegment = new WildCardRawSegment(prefix, null, null);
                        break;
                    }
                    if (lexer.peekChar() == '*') {
                        lexer.skipChar();
                        rawSegment = PrefixRawSegment.INSTANCE;
                        break;
                    }
                    rawSegment = new WildCardRawSegment(prefix, null, lexer.nextText());
                    break;
                }
                default: {
                    if (prefix == null) {
                        Void void_ = lexer.unexpectedChar("({*");
                        throw null;
                    }
                    rawSegment = new NormalRawSegment(prefix, null, null);
                }
            }
        }
        return rawSegment;
    }

    private final NormalRawSegment parseNormalSegment(BRouterUriLexer lexer) {
        SegmentParts parts = null;
        String text = null;
        if (lexer.peekChar() == '(') {
            parts = this.parseSegmentParts(lexer);
        } else {
            text = lexer.nextText();
        }
        return new NormalRawSegment(text, parts, !lexer.reachEnd() && (!lexer.isReservedChar() || lexer.peekChar() == '(') ? this.parseNormalSegment(lexer) : null);
    }

    private final SegmentParts parseSegmentParts(BRouterUriLexer lexer) {
        String string;
        lexer.match('(');
        if (lexer.peekChar() == '?') {
            lexer.skipChar();
            lexer.match('<');
            String string2 = lexer.nextText();
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            lexer.match('>');
            string = string2;
        } else {
            string = null;
        }
        String name = string;
        ArrayList innerSegments = new ArrayList(2);
        Collection collection = innerSegments;
        NormalRawSegment normalRawSegment = this.parseNormalSegment(lexer);
        boolean bl = false;
        collection.add(normalRawSegment);
        while (lexer.peekChar() == '|') {
            lexer.skipChar();
            collection = innerSegments;
            normalRawSegment = this.parseNormalSegment(lexer);
            bl = false;
            collection.add(normalRawSegment);
        }
        lexer.match(')');
        return new SegmentParts(name, innerSegments);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0011\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u00a8\u0006\b"}, d2={"Lcom/bilibili/brouter/common/util/matcher/RawSegmentsParser$Companion;", "", "()V", "forceScheme", "Lcom/bilibili/brouter/common/util/matcher/RawSegmentsParser;", "invoke", "defaultScheme", "", "brouter-runtime-common"})
    public static final class Companion {
        @NotNull
        public final RawSegmentsParser invoke(@NotNull String defaultScheme) {
            Intrinsics.checkParameterIsNotNull((Object)defaultScheme, (String)"defaultScheme");
            BRouterUriLexer lexer = new BRouterUriLexer(defaultScheme);
            NormalRawSegment defaultSchemeSegment = new NormalRawSegment(lexer.nextText(), null, null);
            if (!lexer.reachEnd()) {
                throw (Throwable)new InvalidUriException("Invalid default scheme '" + defaultScheme + "'.");
            }
            return new NoSchemeSegmentsParser(defaultSchemeSegment);
        }

        @NotNull
        public final RawSegmentsParser forceScheme() {
            return ForSchemeSegmentsParser.INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

