/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.brouter.common.util.matcher;

import com.bilibili.brouter.common.util.matcher.Segment;
import com.bilibili.brouter.common.util.matcher.SegmentKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/bilibili/brouter/common/util/matcher/WildCardSegment;", "Lcom/bilibili/brouter/common/util/matcher/Segment;", "prefix", "", "suffix", "(Ljava/lang/String;Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "segment", "getSegment", "getSuffix", "type", "", "getType", "()I", "doCompareTo", "other", "match", "", "input", "brouter-runtime-common"})
public final class WildCardSegment
extends Segment<WildCardSegment> {
    @NotNull
    private final String prefix;
    @NotNull
    private final String suffix;

    @Override
    protected int getType() {
        return 1;
    }

    @Override
    @NotNull
    public String getSegment() {
        return this.prefix + '*' + this.suffix;
    }

    @Override
    public boolean match(@NotNull String input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return input.length() >= this.prefix.length() + this.suffix.length() && StringsKt.startsWith$default((String)input, (String)this.prefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)input, (String)this.suffix, (boolean)false, (int)2, null);
    }

    @Override
    protected int doCompareTo(@NotNull WildCardSegment other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int diff = SegmentKt.compareWithLength(this.prefix, other.prefix);
        if (diff == 0) {
            diff = SegmentKt.compareWithLength(this.suffix, other.suffix);
        }
        return diff;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    public WildCardSegment(@NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        super(null);
        this.prefix = prefix;
        this.suffix = suffix;
    }
}

