/*
 * Decompiled with CFR 0.152.
 */
package com.burgstaller.okhttp;

import android.util.Log;
import com.burgstaller.okhttp.digest.CachingAuthenticator;
import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AuthenticationCacheInterceptor
implements Interceptor {
    private static final String TAG = "AuthInt";
    private final Map<String, CachingAuthenticator> authCache;

    public AuthenticationCacheInterceptor(Map<String, CachingAuthenticator> authCache) {
        this.authCache = authCache;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String host = request.url().host();
        CachingAuthenticator authenticator = this.authCache.get(host);
        Request authRequest = null;
        if (authenticator != null && (authRequest = authenticator.authenticateWithState(request)) != null) {
            Log.d((String)TAG, (String)("reusing auth from cache: " + authenticator));
        }
        if (authRequest == null) {
            authRequest = request;
        }
        return chain.proceed(authRequest);
    }
}

