/*
 * Decompiled with CFR 0.152.
 */
package com.burgstaller.okhttp;

import com.burgstaller.okhttp.digest.CachingAuthenticator;
import java.io.IOException;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class CachingAuthenticatorDecorator
implements Authenticator {
    private final Authenticator innerAuthenticator;
    private final Map<String, CachingAuthenticator> authCache;

    public CachingAuthenticatorDecorator(Authenticator innerAuthenticator, Map<String, CachingAuthenticator> authCache) {
        this.innerAuthenticator = innerAuthenticator;
        this.authCache = authCache;
    }

    public Request authenticate(Route route, Response response) throws IOException {
        String authorizationValue;
        Request authenticated = this.innerAuthenticator.authenticate(route, response);
        if (authenticated != null && (authorizationValue = authenticated.header("Authorization")) != null && this.innerAuthenticator instanceof CachingAuthenticator) {
            this.authCache.put(authenticated.url().host(), (CachingAuthenticator)this.innerAuthenticator);
        }
        return authenticated;
    }
}

