/*
 * Decompiled with CFR 0.152.
 */
package com.constantcontact.v2;

import com.constantcontact.v2.Paged;
import com.constantcontact.v2.library.File;
import com.constantcontact.v2.library.FileSortOrder;
import com.constantcontact.v2.library.FileSource;
import com.constantcontact.v2.library.FileTypeQuery;
import com.constantcontact.v2.library.FileUploadStatus;
import com.constantcontact.v2.library.Folder;
import com.constantcontact.v2.library.FolderSortOrder;
import com.constantcontact.v2.library.LibraryInfo;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface LibraryService {
    @GET(value="v2/library/info")
    public Call<LibraryInfo> getLibraryInfo();

    @GET(value="v2/library/folders")
    public Call<Paged<Folder>> getFolders(@Query(value="limit") int var1, @Query(value="sort_by") FolderSortOrder var2);

    @GET
    public Call<Paged<Folder>> getFolders(@Url String var1);

    @POST(value="v2/library/folders")
    public Call<Folder> createFolder(@Body Folder var1);

    @GET(value="v2/library/folders/{folderId}")
    public Call<Folder> getFolder(@Path(value="folderId") String var1);

    @PUT(value="v2/library/folders/{folderId}?include_payload=TRUE")
    public Call<Folder> updateFolder(@Path(value="folderId") String var1, @Body Folder var2);

    @DELETE(value="v2/library/folders/{folderId}")
    public Call<Response> deleteFolder(@Path(value="folderId") String var1);

    @GET(value="v2/library/files")
    public Call<Paged<File>> getFiles(@Query(value="limit") int var1, @Query(value="sort_by") FileSortOrder var2, @Query(value="source") FileSource var3, @Query(value="type") FileTypeQuery var4);

    @GET
    public Call<Paged<File>> getFiles(@Url String var1);

    @GET(value="v2/library/folders/{folderId}/files")
    public Call<Paged<File>> getFilesByFolder(@Path(value="folderId") String var1, @Query(value="limit") int var2, @Query(value="sort_by") FileSortOrder var3, @Query(value="source") FileSource var4, @Query(value="type") FileTypeQuery var5);

    @GET
    public Call<Paged<File>> getFilesByFolder(@Url String var1);

    @GET(value="v2/library/files/{fileId}")
    public Call<File> getFile(@Path(value="fileId") String var1);

    @PUT(value="v2/library/files/{fileId}?include_payload=TRUE")
    public Call<File> updateFile(@Path(value="fileId") String var1, @Body File var2);

    @PUT(value="v2/library/folders/{folderId}/files")
    public Call<File> moveFiles(@Path(value="folderId") String var1, @Body String[] var2);

    @DELETE(value="v2/library/files/{fileId}")
    public Call<Response<Void>> deleteFile(@Path(value="fileId") String var1);

    @DELETE(value="v2/library/folders/trash/files")
    public Call<Response<Void>> deleteFilesInTrash();

    @GET(value="v2/library/files/uploadstatus/{fileId}")
    public Call<FileUploadStatus[]> getFileUploadStatus(@Path(value="fileId") String var1);

    @Multipart
    @Headers(value={"Content-Type: multipart/form-data"})
    @POST(value="v2/library/files")
    public Call<Response<Void>> uploadFile(@Part(value="data") RequestBody var1, @Part(value="description") RequestBody var2, @Part(value="file_name") RequestBody var3, @Part(value="file_type") RequestBody var4, @Part(value="folder_id") RequestBody var5, @Part(value="source") RequestBody var6);
}

