/*
 *    Copyright 2020 Criteo
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.criteo.publisher.csm;

import androidx.annotation.NonNull;
import com.criteo.publisher.util.BuildConfigWrapper;
import java.util.Collection;

class BoundedMetricRepository extends MetricRepository {

  @NonNull
  private final MetricRepository delegate;

  @NonNull
  private final BuildConfigWrapper buildConfigWrapper;

  BoundedMetricRepository(
      @NonNull MetricRepository delegate,
      @NonNull BuildConfigWrapper buildConfigWrapper
  ) {
    this.delegate = delegate;
    this.buildConfigWrapper = buildConfigWrapper;
  }

  @Override
  void addOrUpdateById(@NonNull String impressionId, @NonNull MetricUpdater updater) {
    if (getTotalSize() >= buildConfigWrapper.getMaxSizeOfCsmMetricsFolder()) {
      if (!contains(impressionId)) {
        return;
      }
    }

    delegate.addOrUpdateById(impressionId, updater);
  }

  @Override
  void moveById(@NonNull String impressionId, @NonNull MetricMover mover) {
    delegate.moveById(impressionId, mover);
  }

  @NonNull
  @Override
  Collection<Metric> getAllStoredMetrics() {
    return delegate.getAllStoredMetrics();
  }

  @Override
  int getTotalSize() {
    return delegate.getTotalSize();
  }

  @Override
  boolean contains(@NonNull String impressionId) {
    return delegate.contains(impressionId);
  }
}
