/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.booster.gradle;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.sdklib.BuildToolInfo;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;

class VariantScopeV30 {
    VariantScopeV30() {
    }

    @NotNull
    static BaseExtension getExtension(@NotNull VariantScope scope) {
        return (BaseExtension)scope.getGlobalScope().getExtension();
    }

    @NotNull
    static Collection<File> getMergedManifests(@NotNull VariantScope scope) {
        return scope.getOutput((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS).getFiles();
    }

    @NotNull
    static Collection<File> getMergedRes(@NotNull VariantScope scope) {
        return scope.getOutput((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_RES).getFiles();
    }

    @NotNull
    static Collection<File> getMergedAssets(@NotNull VariantScope scope) {
        return scope.getOutput((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_ASSETS).getFiles();
    }

    @NotNull
    static Collection<File> getProcessedRes(@NotNull VariantScope scope) {
        return scope.getOutput((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.PROCESSED_RES).getFiles();
    }

    @NotNull
    static Collection<File> getAllClasses(@NotNull VariantScope scope) {
        return scope.getOutput((TaskOutputHolder.OutputType)TaskOutputHolder.AnchorOutputType.ALL_CLASSES).getFiles();
    }

    @NotNull
    static Collection<File> getSymbolList(@NotNull VariantScope scope) {
        return VariantScopeV30.getOutput(scope, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.SYMBOL_LIST);
    }

    @NotNull
    static Collection<File> getSymbolListWithPackageName(@NotNull VariantScope scope) {
        return VariantScopeV30.getOutput(scope, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.SYMBOL_LIST_WITH_PACKAGE_NAME);
    }

    @NotNull
    static Collection<File> getAar(@NotNull VariantScope scope) {
        return VariantScopeV30.getOutput(scope, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.AAR);
    }

    @NotNull
    static Collection<File> getApk(@NotNull VariantScope scope) {
        return VariantScopeV30.getOutput(scope, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.APK);
    }

    @NotNull
    static Collection<File> getJavac(@NotNull VariantScope scope) {
        return VariantScopeV30.getOutput(scope, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.JAVAC);
    }

    @NotNull
    static Map<String, Collection<File>> getAllArtifacts(@NotNull VariantScope scope) {
        return Stream.concat(Arrays.stream(TaskOutputHolder.TaskOutputType.values()), Arrays.stream(TaskOutputHolder.AnchorOutputType.values())).collect(Collectors.toMap(Enum::name, v -> VariantScopeV30.getOutput(scope, (TaskOutputHolder.OutputType)v)));
    }

    @NotNull
    static Collection<File> getOutput(@NotNull VariantScope scope, @NotNull TaskOutputHolder.OutputType type) {
        try {
            return scope.getOutput(type).getFiles();
        }
        catch (RuntimeException e) {
            return Collections.emptySet();
        }
    }

    @NotNull
    static BuildToolInfo getBuildTools(@NotNull VariantScope scope) {
        return scope.getGlobalScope().getAndroidBuilder().getBuildToolInfo();
    }

    @NotNull
    static Collection<File> getRawAndroidResources(@NotNull VariantScope scope) {
        try {
            Method computeResourceSetList = MergeResources.class.getDeclaredMethod("computeResourceSetList", new Class[0]);
            computeResourceSetList.setAccessible(true);
            List resources = (List)computeResourceSetList.invoke((Object)scope.getVariantData().mergeResourcesTask, new Object[0]);
            return resources.stream().map(it -> it.getSourceFiles()).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        catch (Throwable e) {
            return Collections.emptySet();
        }
    }

    @NotNull
    static File getDataBindingDependencyArtifacts(@NotNull VariantScope scope) {
        File file = scope.getBuildFolderForDataBindingCompiler();
        return new File(file, "dependent-lib-artifacts");
    }

    @NotNull
    public static ProcessAndroidResources getProcessResourcesTask(@NotNull VariantScope scope) {
        TaskContainer tasks = scope.getGlobalScope().getProject().getTasks();
        return (ProcessAndroidResources)tasks.getByName(scope.getProcessResourcesTask().getName());
    }
}

