/*
 * Decompiled with CFR 0.152.
 */
package com.caseyjbrooks.clog;

import com.caseyjbrooks.clog.Clog;
import com.caseyjbrooks.clog.ClogLogger;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class DefaultLogger
implements ClogLogger {
    private Clog.Priority priority;

    public DefaultLogger() {
        this(Clog.Priority.DEFAULT);
    }

    public DefaultLogger(Clog.Priority priority) {
        this.priority = priority;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public int log(String tag, String message) {
        AnsiConsole.out.println(this.getAnsiLevelString().a(tag + ": ").a(message));
        return 0;
    }

    @Override
    public int log(String tag, String message, Throwable throwable) {
        AnsiConsole.out.println(this.getAnsiLevelString().a(tag + ": ").a(message).a(" (" + throwable.getMessage() + ")"));
        return 0;
    }

    @Override
    public Clog.Priority priority() {
        return this.priority;
    }

    private Ansi getAnsiLevelString() {
        if (this.priority != null) {
            switch (this.priority) {
                case VERBOSE: {
                    return Ansi.ansi().fg(Ansi.Color.GREEN).a("[VERBOSE] ").reset();
                }
                case DEBUG: {
                    return Ansi.ansi().fg(Ansi.Color.BLUE).a("[DEBUG] ").reset();
                }
                case INFO: {
                    return Ansi.ansi().fg(Ansi.Color.CYAN).a("[INFO] ").reset();
                }
                case WARNING: {
                    return Ansi.ansi().fg(Ansi.Color.YELLOW).a("[WARN] ").reset();
                }
                case ERROR: {
                    return Ansi.ansi().fg(Ansi.Color.RED).a("[ERROR] ").reset();
                }
                case FATAL: {
                    return Ansi.ansi().fg(Ansi.Color.MAGENTA).a("[FATAL] ").reset();
                }
            }
            return Ansi.ansi().fg(Ansi.Color.MAGENTA).a("").reset();
        }
        return Ansi.ansi();
    }

    static {
        System.setProperty("jansi.passthrough", "true");
        AnsiConsole.systemInstall();
    }
}

