/*
 * Decompiled with CFR 0.152.
 */
package com.caseyjbrooks.clog;

import com.caseyjbrooks.clog.ClogProfile;
import com.caseyjbrooks.clog.ProfileSupplier;
import java.util.HashMap;
import java.util.Map;

public class Clog {
    public static final String KEY_V = "v";
    public static final String KEY_D = "d";
    public static final String KEY_I = "i";
    public static final String KEY_W = "w";
    public static final String KEY_E = "e";
    public static final String KEY_WTF = "wtf";
    private static Map<String, ProfileSupplier> profileSuppliers;
    private static Map<String, ClogProfile> profiles;
    private static String currentProfileKey;
    private static ClogProfile currentProfile;

    public static ClogProfile getInstance() {
        if (currentProfile == null) {
            if (profiles == null || profiles.get(currentProfileKey) == null) {
                if (profileSuppliers != null && profileSuppliers.get(currentProfileKey) != null) {
                    currentProfile = profileSuppliers.get(currentProfileKey).get();
                    profiles.put(currentProfileKey, currentProfile);
                } else {
                    currentProfile = new ClogProfile();
                }
            } else {
                currentProfile = profiles.get(null);
            }
        }
        return currentProfile;
    }

    public static String getStackTraceString(Throwable tr) {
        return Clog.getInstance().getStackTraceString(tr);
    }

    public static String format(String message, Object ... args) {
        return Clog.getInstance().format(message, args);
    }

    public static ClogProfile tag(String tag) {
        return Clog.getInstance().tag(tag);
    }

    public static ClogProfile noTag() {
        return Clog.getInstance().tag("");
    }

    public static int logger(String logger, Throwable throwable) {
        return Clog.getInstance().logger(logger, throwable);
    }

    public static int logger(String logger, String message, Object ... args) {
        return Clog.getInstance().logger(logger, message, args);
    }

    public static int logger(String logger, String message, Throwable throwable, Object ... args) {
        return Clog.getInstance().logger(logger, message, throwable, args);
    }

    public static int log(Throwable throwable) {
        return Clog.getInstance().log(throwable);
    }

    public static int log(String message, Object ... args) {
        return Clog.getInstance().log(message, args);
    }

    public static int log(String message, Throwable throwable, Object ... args) {
        return Clog.getInstance().log(message, throwable, args);
    }

    public static int v(Throwable throwable) {
        return Clog.getInstance().v(throwable);
    }

    public static int v(String message, Object ... args) {
        return Clog.getInstance().v(message, args);
    }

    public static int v(String message, Throwable throwable, Object ... args) {
        return Clog.getInstance().v(message, throwable, args);
    }

    public static int d(Throwable throwable) {
        return Clog.getInstance().d(throwable);
    }

    public static int d(String message, Object ... args) {
        return Clog.getInstance().d(message, args);
    }

    public static int d(String message, Throwable throwable, Object ... args) {
        return Clog.getInstance().d(message, throwable, args);
    }

    public static int i(Throwable throwable) {
        return Clog.getInstance().i(throwable);
    }

    public static int i(String message, Object ... args) {
        return Clog.getInstance().i(message, args);
    }

    public static int i(String message, Throwable throwable, Object ... args) {
        return Clog.getInstance().i(message, throwable, args);
    }

    public static int w(Throwable throwable) {
        return Clog.getInstance().w(throwable);
    }

    public static int w(String message, Object ... args) {
        return Clog.getInstance().w(message, args);
    }

    public static int w(String message, Throwable throwable, Object ... args) {
        return Clog.getInstance().w(message, throwable, args);
    }

    public static int e(Throwable throwable) {
        return Clog.getInstance().e(throwable);
    }

    public static int e(String message, Object ... args) {
        return Clog.getInstance().e(message, args);
    }

    public static int e(String message, Throwable throwable, Object ... args) {
        return Clog.getInstance().e(message, throwable, args);
    }

    public static int wtf(Throwable throwable) {
        return Clog.getInstance().wtf(throwable);
    }

    public static int wtf(String message, Object ... args) {
        return Clog.getInstance().wtf(message, args);
    }

    public static int wtf(String message, Throwable throwable, Object ... args) {
        return Clog.getInstance().wtf(message, throwable, args);
    }

    public static void addProfile(String key, ProfileSupplier clog) {
        if (profileSuppliers == null) {
            profileSuppliers = new HashMap<String, ProfileSupplier>();
        }
        profileSuppliers.put(key, clog);
    }

    public static void removeProfile(String key) {
        if (profiles == null) {
            profiles = new HashMap<String, ClogProfile>();
        }
        profiles.remove(key);
    }

    public static ClogProfile setCurrentProfile(String key) {
        if (profiles == null) {
            profiles = new HashMap<String, ClogProfile>();
        }
        currentProfileKey = key;
        currentProfile = profiles.get(key);
        return Clog.getInstance();
    }

    public static ClogProfile setCurrentProfile(String key, ProfileSupplier clog) {
        Clog.addProfile(key, clog);
        return Clog.setCurrentProfile(key);
    }

    public static Map<String, ClogProfile> getProfiles() {
        if (profiles == null) {
            profiles = new HashMap<String, ClogProfile>();
        }
        return profiles;
    }

    public static void setAllProfiles(Map<String, ClogProfile> profiles) {
        if (profiles == null) {
            throw new NullPointerException("profiles cannot be null");
        }
        Clog.profiles = profiles;
    }

    public static enum Priority {
        VERBOSE("v", 1),
        DEBUG("d", 2),
        INFO("i", 3),
        DEFAULT(null, 4),
        WARNING("e", 5),
        ERROR("e", 6),
        FATAL("wtf", 7);

        private final int priority;
        private final String key;

        private Priority(String key, int priority) {
            this.key = key;
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getKey() {
            return this.key;
        }

        public static Priority getByKey(String key) {
            for (Priority priority : Priority.values()) {
                if (!priority.toString().equalsIgnoreCase(key) && (priority.getKey() != null || key != null) && (priority.getKey() == null || !priority.getKey().equalsIgnoreCase(key))) continue;
                return priority;
            }
            return DEFAULT;
        }
    }
}

