/*
 * Decompiled with CFR 0.152.
 */
package com.caseyjbrooks.clog;

import com.caseyjbrooks.clog.Clog;
import com.caseyjbrooks.clog.ClogFormatter;
import com.caseyjbrooks.clog.ClogLogger;
import com.caseyjbrooks.clog.DefaultLogger;
import com.caseyjbrooks.clog.IClog;
import com.caseyjbrooks.clog.parseltongue.Parseltongue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ClogProfile
extends IClog {
    private Map<String, ClogLogger> loggers;
    private ClogFormatter formatter;
    private String lastTag;
    private String lastLog;
    private String temporaryTag;
    private Stack<String> tagStack;
    private List<String> tagWhitelist;
    private List<String> tagBlacklist;
    private List<String> loggerWhitelist;
    private List<String> loggerBlacklist;
    private Clog.Priority minPriority;
    private Clog.Priority maxPriority;

    public ClogProfile() {
        this.temporaryTag = null;
        this.tagStack = new Stack();
        this.loggers = new HashMap<String, ClogLogger>();
        this.loggers.put(null, new DefaultLogger(Clog.Priority.DEFAULT));
        this.loggers.put("v", new DefaultLogger(Clog.Priority.VERBOSE));
        this.loggers.put("d", new DefaultLogger(Clog.Priority.DEBUG));
        this.loggers.put("i", new DefaultLogger(Clog.Priority.INFO));
        this.loggers.put("w", new DefaultLogger(Clog.Priority.WARNING));
        this.loggers.put("e", new DefaultLogger(Clog.Priority.ERROR));
        this.loggers.put("wtf", new DefaultLogger(Clog.Priority.FATAL));
        this.formatter = new Parseltongue();
        this.tagWhitelist = new ArrayList<String>();
        this.tagBlacklist = new ArrayList<String>();
        this.loggerWhitelist = new ArrayList<String>();
        this.loggerBlacklist = new ArrayList<String>();
        this.minPriority = null;
        this.maxPriority = null;
    }

    public ClogProfile(Map<String, ClogLogger> loggers, ClogFormatter formatter) {
        this.tagStack = new Stack();
        this.loggers = loggers;
        this.formatter = formatter;
        this.tagWhitelist = new ArrayList<String>();
        this.tagBlacklist = new ArrayList<String>();
        this.loggerWhitelist = new ArrayList<String>();
        this.loggerBlacklist = new ArrayList<String>();
        this.minPriority = null;
        this.maxPriority = null;
    }

    public String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public String format(String message, Object ... args) {
        return this.formatter.format(message, args);
    }

    @Override
    public int loggerInternal(String logger, String message, Throwable throwable, Object ... args) {
        ClogLogger currentLogger = null;
        String currentTag = this.getTag();
        this.temporaryTag = null;
        boolean inWhitelist = false;
        for (String whiteListedTag : this.tagWhitelist) {
            if (!currentTag.equals(whiteListedTag)) continue;
            inWhitelist = true;
            break;
        }
        boolean inBlacklist = false;
        for (String blackListedTag : this.tagBlacklist) {
            if (!currentTag.equals(blackListedTag)) continue;
            inBlacklist = true;
            break;
        }
        if (this.tagWhitelist.size() > 0 && !inWhitelist || this.tagBlacklist.size() > 0 && inBlacklist) {
            return 0;
        }
        if (this.loggers != null) {
            if (this.loggers.containsKey(logger)) {
                currentLogger = this.loggers.get(logger);
            }
            if (currentLogger == null && this.loggers.containsKey(null)) {
                currentLogger = this.loggers.get(null);
            }
            if (currentLogger == null) {
                currentLogger = new DefaultLogger();
            }
        } else {
            currentLogger = new DefaultLogger();
        }
        inWhitelist = false;
        for (String whiteListedLogger : this.loggerWhitelist) {
            if (logger == null) {
                if (whiteListedLogger != null) continue;
                inWhitelist = true;
                break;
            }
            if (!logger.equals(whiteListedLogger)) continue;
            inWhitelist = true;
            break;
        }
        inBlacklist = false;
        for (String blackListedLogger : this.loggerBlacklist) {
            if (logger == null) {
                if (blackListedLogger != null) continue;
                inBlacklist = true;
                break;
            }
            if (!logger.equals(blackListedLogger)) continue;
            inBlacklist = true;
            break;
        }
        if (this.loggerWhitelist.size() > 0 && !inWhitelist || this.loggerBlacklist.size() > 0 && inBlacklist) {
            return 0;
        }
        if (this.minPriority != null && currentLogger.priority().getPriority() < this.minPriority.getPriority()) {
            return 0;
        }
        if (this.maxPriority != null && currentLogger.priority().getPriority() > this.maxPriority.getPriority()) {
            return 0;
        }
        if (currentLogger.isActive()) {
            String currentMessage = message != null ? this.formatter.format(message, args) : (throwable != null ? this.getStackTraceString(throwable) : "");
            if (throwable == null) {
                this.lastTag = currentTag;
                this.lastLog = currentMessage;
                return currentLogger.log(currentTag, currentMessage);
            }
            this.lastTag = currentTag;
            this.lastLog = currentMessage;
            return currentLogger.log(currentTag, currentMessage, throwable);
        }
        return 0;
    }

    public Map<String, ClogLogger> getLoggers() {
        return this.loggers;
    }

    public List<String> getLoggerKeys() {
        return new ArrayList<String>(this.loggers.keySet());
    }

    public void setLoggers(Map<String, ClogLogger> loggers) {
        this.loggers = loggers;
    }

    public void addLogger(String key, ClogLogger logger) {
        this.loggers.put(key, logger);
    }

    public void removeLogger(String key) {
        this.loggers.remove(key);
    }

    public void setFormatter(ClogFormatter formatter) {
        this.formatter = formatter;
    }

    public ClogFormatter getFormatter() {
        return this.formatter;
    }

    public String getLastTag() {
        return this.lastTag;
    }

    public String getLastLog() {
        return this.lastLog;
    }

    public void flush() {
        this.lastTag = null;
        this.lastLog = null;
    }

    public void addTagToWhitelist(String tag) {
        this.tagWhitelist.add(tag);
    }

    public void addTagToBlacklist(String tag) {
        this.tagBlacklist.add(tag);
    }

    public void clearTagWhitelist() {
        this.tagWhitelist.clear();
    }

    public void clearTagBlacklist() {
        this.tagBlacklist.clear();
    }

    public void addLoggerToWhitelist(String tag) {
        this.loggerWhitelist.add(tag);
    }

    public void addLoggerToBlacklist(String tag) {
        this.loggerBlacklist.add(tag);
    }

    public void clearLoggerWhitelist() {
        this.loggerWhitelist.clear();
    }

    public void clearLoggerBlacklist() {
        this.loggerBlacklist.clear();
    }

    public void setMinPriority(Clog.Priority minPriority) {
        this.minPriority = minPriority;
    }

    public void setMaxPriority(Clog.Priority maxPriority) {
        this.maxPriority = maxPriority;
    }

    public ClogProfile tag(String tag) {
        this.temporaryTag = tag;
        return this;
    }

    public void pushTag(String tag) {
        this.tagStack.push(tag);
    }

    public void popTag() {
        this.tagStack.pop();
    }

    public String getCurrentTag() {
        return this.getTag();
    }

    private String getTag() {
        if (this.temporaryTag != null) {
            return this.temporaryTag;
        }
        if (this.tagStack.size() > 0) {
            return this.tagStack.peek();
        }
        return this.findCallerClassName();
    }

    private String findCallerClassName() {
        return this.findCallerClassName(null);
    }

    private String findCallerClassName(Throwable t) {
        StackTraceElement[] frames;
        String className = "Unknown";
        if (t == null) {
            t = new Throwable();
        }
        if ((frames = t.getStackTrace()).length == 0) {
            return className;
        }
        for (int f = 0; f < frames.length && this.isClassnameInternal(className = frames[f].getClassName()); ++f) {
        }
        return this.parseClassName(className);
    }

    private String parseClassName(String fullName) {
        int lastdollar;
        int lastdot = fullName.lastIndexOf(46);
        String simpleName = fullName;
        if (lastdot != -1) {
            simpleName = fullName.substring(lastdot + 1);
        }
        if ((lastdollar = simpleName.lastIndexOf(36)) != -1) {
            simpleName = simpleName.substring(0, lastdollar);
        }
        return simpleName;
    }

    protected boolean isClassnameInternal(String className) {
        String[] classNames;
        for (String s : classNames = new String[]{Clog.class.getName(), this.getClass().getName(), ClogProfile.class.getName(), IClog.class.getName()}) {
            if (!className.equals(s)) continue;
            return true;
        }
        return false;
    }
}

