/*
 * Decompiled with CFR 0.152.
 */
package com.caseyjbrooks.clog.parseltongue;

import com.caseyjbrooks.clog.parseltongue.Incantation;
import com.caseyjbrooks.clog.parseltongue.Parseltongue;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class MethodIncantation
implements Incantation {
    private final String name;
    private final Object host;
    private final Method method;

    public MethodIncantation(String name, Object host, Method method) {
        this.name = name;
        this.host = host;
        this.method = method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object call(Object reagent, Object ... reagents) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        ArrayList<Object> params = new ArrayList<Object>();
        if (reagent != null) {
            params.add(reagent);
        } else {
            params.add(new Parseltongue.NullObject());
        }
        if (reagents != null && reagents.length > 0) {
            for (int i = 0; i < reagents.length; ++i) {
                if (reagents[i] != null) {
                    params.add(reagents[i]);
                    continue;
                }
                params.add(new Parseltongue.NullObject());
            }
        }
        if (parameterTypes.length == params.size()) {
            boolean methodMatch = true;
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) instanceof Parseltongue.NullObject || parameterTypes[i].equals(Byte.TYPE) && params.get(i).getClass().equals(Byte.class) || parameterTypes[i].equals(Short.TYPE) && params.get(i).getClass().equals(Short.class) || parameterTypes[i].equals(Integer.TYPE) && params.get(i).getClass().equals(Integer.class) || parameterTypes[i].equals(Long.TYPE) && params.get(i).getClass().equals(Long.class) || parameterTypes[i].equals(Float.TYPE) && params.get(i).getClass().equals(Float.class) || parameterTypes[i].equals(Double.TYPE) && params.get(i).getClass().equals(Double.class) || parameterTypes[i].equals(Boolean.TYPE) && params.get(i).getClass().equals(Boolean.class) || parameterTypes[i].isAssignableFrom(params.get(i).getClass())) continue;
                methodMatch = false;
                break;
            }
            if (methodMatch) {
                Object[] objects = new Object[params.size()];
                for (int i = 0; i < params.size(); ++i) {
                    objects[i] = params.get(i) instanceof Parseltongue.NullObject ? null : params.get(i);
                }
                try {
                    return this.method.invoke(this.host, objects);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

