/*
 * Decompiled with CFR 0.152.
 */
package com.caseyjbrooks.clog.parseltongue;

import com.caseyjbrooks.clog.parseltongue.Token;
import java.util.LinkedList;
import java.util.Stack;

class TokenStream {
    private LinkedList<Character> chars = new LinkedList();
    private Stack<Token> ungetTokens;
    private int column;

    TokenStream(String expression) {
        for (int i = 0; i < expression.length(); ++i) {
            this.chars.add(Character.valueOf(expression.charAt(i)));
        }
        this.ungetTokens = new Stack();
    }

    Token get() {
        try {
            if (this.ungetTokens.size() > 0) {
                return this.ungetTokens.pop();
            }
            if (this.chars.size() > 0) {
                char ch = this.chars.removeFirst().charValue();
                ++this.column;
                switch (ch) {
                    case ' ': {
                        return this.get();
                    }
                    case '|': {
                        return new Token(Token.Type.PIPE, "|");
                    }
                    case '.': {
                        return new Token(Token.Type.DOT, ".");
                    }
                    case '@': {
                        return new Token(Token.Type.AT, "@");
                    }
                    case '$': {
                        return new Token(Token.Type.DOLLARSIGN, "$");
                    }
                    case '\'': {
                        return new Token(Token.Type.QUOTE, "'");
                    }
                    case ',': {
                        return new Token(Token.Type.COMMA, ",");
                    }
                    case '#': {
                        if (this.chars.peekFirst().charValue() == '{') {
                            this.chars.removeFirst();
                            ++this.column;
                            return new Token(Token.Type.CLOG_START, "#{");
                        }
                        return new Token(Token.Type.HASH, "#");
                    }
                    case '{': {
                        if (this.chars.peekFirst().charValue() == '}') {
                            return new Token(Token.Type.CLOG_SIMPLE, "{}");
                        }
                        return new Token(Token.Type.LCURLYBRACE, "{");
                    }
                    case '}': {
                        return new Token(Token.Type.RCURLYBRACE, "}");
                    }
                    case '[': {
                        return new Token(Token.Type.LBRACKET, "[");
                    }
                    case ']': {
                        return new Token(Token.Type.RBRACKET, "]");
                    }
                    case '(': {
                        return new Token(Token.Type.LPAREN, "(");
                    }
                    case ')': {
                        return new Token(Token.Type.RPAREN, ")");
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        String s = "";
                        s = s + ch;
                        while (this.chars.size() > 0 && this.chars.getFirst() != null && Character.isDigit(this.chars.getFirst().charValue())) {
                            s = s + this.chars.removeFirst();
                            ++this.column;
                        }
                        return new Token(Token.Type.NUMBER, Integer.parseInt(s));
                    }
                }
                String s = "";
                s = s + ch;
                while (this.chars.size() > 0 && this.chars.getFirst() != null && Character.isLetter(this.chars.getFirst().charValue())) {
                    s = s + this.chars.removeFirst();
                    ++this.column;
                }
                s = s.replaceAll("\\W", "");
                return new Token(Token.Type.WORD, s);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    Token getAny() {
        String s = "";
        if (this.ungetTokens.size() > 0) {
            while (this.ungetTokens.size() > 0) {
                Token token = this.ungetTokens.pop();
                if (token == null) continue;
                s = s + token.getStringValue();
            }
        }
        if (this.chars.size() > 0) {
            while (this.chars.size() > 0 && this.chars.peekFirst() != null) {
                char ch = this.chars.removeFirst().charValue();
                ++this.column;
                if (ch == '#' && this.chars.peekFirst().charValue() == '{') {
                    this.chars.removeFirst();
                    ++this.column;
                    this.ungetTokens.push(new Token(Token.Type.CLOG_START));
                    return new Token(Token.Type.ANY, s);
                }
                if (ch == '{' && this.chars.peekFirst().charValue() == '}') {
                    this.ungetTokens.push(new Token(Token.Type.CLOG_SIMPLE));
                    return new Token(Token.Type.ANY, s);
                }
                s = s + ch;
            }
            return new Token(Token.Type.ANY, s);
        }
        return new Token(Token.Type.ANY, "");
    }

    Token getString() {
        String s = "";
        if (this.ungetTokens.size() > 0) {
            while (this.ungetTokens.size() > 0) {
                Token token = this.ungetTokens.pop();
                if (token == null) continue;
                s = s + token.getStringValue();
            }
        }
        if (this.chars.size() > 0) {
            while (this.chars.size() > 0 && this.chars.peekFirst() != null) {
                char ch = this.chars.removeFirst().charValue();
                ++this.column;
                if (ch == '\'') {
                    this.ungetTokens.push(new Token(Token.Type.QUOTE));
                    return new Token(Token.Type.STRING, s);
                }
                s = s + ch;
            }
            return new Token(Token.Type.STRING, s);
        }
        return new Token(Token.Type.STRING, "");
    }

    void unget(Token token) {
        this.ungetTokens.push(token);
    }

    boolean hasTokens() {
        if (this.ungetTokens != null && this.ungetTokens.size() > 0) {
            return true;
        }
        return this.chars != null && this.chars.size() > 0;
    }

    int getColumn() {
        return this.column;
    }

    void unclog() {
        if (this.ungetTokens.size() > 0) {
            while (this.ungetTokens.size() > 0) {
                Token token = this.ungetTokens.pop();
                if (token == null || !token.equals(Token.Type.RCURLYBRACE)) continue;
                return;
            }
        }
        if (this.chars.size() > 0) {
            while (this.chars.size() > 0 && this.chars.peekFirst() != null) {
                char ch = this.chars.removeFirst().charValue();
                ++this.column;
                if (ch != '}') continue;
                return;
            }
        }
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.chars.size(); ++i) {
            s = s + this.chars.get(i);
        }
        return s;
    }
}

