/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.CoolSocket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CoolSocket {
    public static final String TAG = CoolSocket.class.getSimpleName();
    public static final int NO_TIMEOUT = -1;
    public static final String HEADER_SEPARATOR = "\nHEADER_END\n";
    public static final String HEADER_ITEM_LENGTH = "length";
    private final ArrayList<ActiveConnection> mConnections = new ArrayList();
    private ExecutorService mExecutor;
    private Thread mServerThread;
    private ServerSocket mServerSocket;
    private SocketAddress mSocketAddress = null;
    private int mSocketTimeout = -1;
    private int mMaxConnections = 10;
    private ServerRunnable mSocketRunnable = new ServerRunnable();

    public CoolSocket() {
    }

    public CoolSocket(int port) {
        this.mSocketAddress = new InetSocketAddress(port);
    }

    public CoolSocket(String address, int port) {
        this.mSocketAddress = new InetSocketAddress(address, port);
    }

    protected abstract void onConnected(ActiveConnection var1);

    public static <T> T connect(Client.ConnectionHandler handler, Class<T> clazz) {
        Client clientInstance = new Client();
        handler.onConnect(clientInstance);
        return clientInstance.getReturn() != null && clazz != null ? (T)clazz.cast(clientInstance.getReturn()) : null;
    }

    public static void connect(final Client.ConnectionHandler handler) {
        new Thread(){

            @Override
            public void run() {
                super.run();
                CoolSocket.connect(handler, null);
            }
        }.start();
    }

    public int getConnectionCountByAddress(InetAddress address) {
        int returnObject = 0;
        for (ActiveConnection activeConnection : this.getConnections()) {
            if (!activeConnection.getAddress().equals(address)) continue;
            ++returnObject;
        }
        return returnObject;
    }

    public synchronized ArrayList<ActiveConnection> getConnections() {
        return this.mConnections;
    }

    public ExecutorService getExecutor() {
        if (this.mExecutor == null) {
            this.mExecutor = Executors.newFixedThreadPool(this.mMaxConnections);
        }
        return this.mExecutor;
    }

    public int getLocalPort() {
        return this.getServerSocket().getLocalPort();
    }

    protected ServerSocket getServerSocket() {
        return this.mServerSocket;
    }

    protected Thread getServerThread() {
        return this.mServerThread;
    }

    public SocketAddress getSocketAddress() {
        return this.mSocketAddress;
    }

    protected ServerRunnable getSocketRunnable() {
        return this.mSocketRunnable;
    }

    public int getSocketTimeout() {
        return this.mSocketTimeout;
    }

    public boolean isComponentsReady() {
        return this.getServerSocket() != null && this.getServerThread() != null && this.getSocketAddress() != null;
    }

    public boolean isInterrupted() {
        return this.getServerThread() == null || this.getServerThread().isInterrupted();
    }

    public boolean isServerAlive() {
        return this.getServerThread() != null && this.getServerThread().isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean respondRequest(final Socket socket) {
        ActiveConnection connectionHandler;
        if (this.getConnections().size() <= this.mMaxConnections || this.mMaxConnections == 0) {
            connectionHandler = new ActiveConnection(socket, this.mSocketTimeout);
            ArrayList<ActiveConnection> arrayList = this.getConnections();
            synchronized (arrayList) {
                this.getConnections().add(connectionHandler);
            }
        } else {
            return false;
        }
        this.getExecutor().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (CoolSocket.this.mSocketTimeout > -1) {
                        connectionHandler.getSocket().setSoTimeout(CoolSocket.this.mSocketTimeout);
                    }
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                CoolSocket.this.onConnected(connectionHandler);
                try {
                    if (!socket.isClosed()) {
                        System.out.println(TAG + ": You should close connections in the end of onConnected(ActiveConnection) method");
                        socket.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    ArrayList<ActiveConnection> arrayList = CoolSocket.this.getConnections();
                    synchronized (arrayList) {
                        CoolSocket.this.getConnections().remove(connectionHandler);
                    }
                }
            }
        });
        return true;
    }

    public void setExecutor(ExecutorService executor) {
        this.mExecutor = executor;
    }

    public void setMaxConnections(int value) {
        this.mMaxConnections = value;
    }

    public void setSocketAddress(SocketAddress address) {
        this.mSocketAddress = address;
    }

    public void setSocketTimeout(int timeout) {
        this.mSocketTimeout = timeout;
    }

    public boolean start() {
        if (this.getServerSocket() == null || this.getServerSocket().isClosed()) {
            try {
                this.mServerSocket = new ServerSocket();
                this.getServerSocket().bind(this.mSocketAddress);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.getServerThread() == null || Thread.State.TERMINATED.equals((Object)this.getServerThread().getState())) {
            this.mServerThread = new Thread(this.getSocketRunnable());
            this.getServerThread().setDaemon(true);
            this.getServerThread().setName(TAG + " Main Thread");
        } else if (this.getServerThread().isAlive()) {
            return false;
        }
        this.getServerThread().start();
        return true;
    }

    public boolean startDelayed(int timeout) {
        long startTime = System.currentTimeMillis();
        while (this.isServerAlive()) {
            if (System.currentTimeMillis() - startTime <= (long)timeout) continue;
            return false;
        }
        return this.start();
    }

    public boolean startEnsured(int timeout) {
        long startTime = System.currentTimeMillis();
        if (!this.startDelayed(timeout)) {
            return false;
        }
        while (!this.isServerAlive()) {
            if (System.currentTimeMillis() - startTime <= (long)timeout) continue;
            return false;
        }
        return true;
    }

    public boolean stop() {
        if (this.isInterrupted()) {
            return false;
        }
        this.getServerThread().interrupt();
        if (!this.getServerSocket().isClosed()) {
            try {
                this.getServerSocket().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void onServerStarted() {
    }

    public void onServerStopped() {
    }

    public void onInternalError(Exception exception) {
    }

    public static class Client {
        private Object mReturn;

        public ActiveConnection connect(SocketAddress socketAddress, int operationTimeout) throws IOException {
            Socket socket = new Socket();
            if (operationTimeout != -1) {
                socket.setSoTimeout(operationTimeout);
            }
            socket.bind(null);
            socket.connect(socketAddress);
            return new ActiveConnection(socket, operationTimeout);
        }

        public Object getReturn() {
            return this.mReturn;
        }

        public void setReturn(Object returnedObject) {
            this.mReturn = returnedObject;
        }

        public static interface ConnectionHandler {
            public void onConnect(Client var1);
        }
    }

    private class ServerRunnable
    implements Runnable {
        private ServerRunnable() {
        }

        @Override
        public void run() {
            try {
                CoolSocket.this.onServerStarted();
                do {
                    Socket request = CoolSocket.this.getServerSocket().accept();
                    if (CoolSocket.this.isInterrupted()) {
                        request.close();
                        continue;
                    }
                    CoolSocket.this.respondRequest(request);
                } while (!CoolSocket.this.isInterrupted());
            }
            catch (IOException e) {
                CoolSocket.this.onInternalError(e);
            }
            finally {
                CoolSocket.this.onServerStopped();
            }
        }
    }

    public static class ActiveConnection {
        private Socket mSocket;
        private int mTimeout = -1;
        private int mId = this.getClass().hashCode();

        public ActiveConnection(Socket socket) {
            this.mSocket = socket;
        }

        public ActiveConnection(Socket socket, int timeout) {
            this(socket);
            this.setTimeout(timeout);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.getSocket() != null && !this.getSocket().isClosed()) {
                System.out.println(TAG + ": Connections should be closed before their references are being destroyed");
                this.getSocket().close();
            }
        }

        public InetAddress getAddress() {
            return this.getSocket().getInetAddress();
        }

        public String getClientAddress() {
            return this.getAddress().getHostAddress();
        }

        public int getId() {
            return this.mId;
        }

        public Socket getSocket() {
            return this.mSocket;
        }

        public long getTimeout() {
            return this.mTimeout;
        }

        public boolean equals(Object obj) {
            return obj instanceof ActiveConnection ? obj.toString().equals(this.toString()) : super.equals(obj);
        }

        public Response receive() throws IOException, TimeoutException, JSONException {
            byte[] buffer = new byte[8096];
            long calculatedTimeout = this.getTimeout() != -1L ? System.currentTimeMillis() + this.getTimeout() : -1L;
            InputStream inputStream = this.getSocket().getInputStream();
            ByteArrayOutputStream headerIndex = new ByteArrayOutputStream();
            ByteArrayOutputStream receivedMessage = new ByteArrayOutputStream();
            Response response = new Response();
            response.remoteAddress = this.getSocket().getRemoteSocketAddress();
            do {
                int len;
                if ((len = inputStream.read(buffer)) > 0) {
                    if (response.totalLength != -1L) {
                        receivedMessage.write(buffer, 0, len);
                        receivedMessage.flush();
                    } else {
                        headerIndex.write(buffer, 0, len);
                        headerIndex.flush();
                        if (headerIndex.toString().contains(CoolSocket.HEADER_SEPARATOR)) {
                            String headerString = headerIndex.toString();
                            int headerEndPoint = headerString.indexOf(CoolSocket.HEADER_SEPARATOR);
                            JSONObject headerJSON = new JSONObject(headerString.substring(0, headerEndPoint));
                            response.totalLength = headerJSON.getLong(CoolSocket.HEADER_ITEM_LENGTH);
                            response.headerIndex = headerJSON;
                            if (headerEndPoint < headerIndex.size()) {
                                receivedMessage.write(headerString.substring(headerEndPoint + CoolSocket.HEADER_SEPARATOR.length()).getBytes());
                            }
                        }
                    }
                }
                if (calculatedTimeout == -1L || System.currentTimeMillis() <= calculatedTimeout) continue;
                throw new TimeoutException("Read timed out!");
            } while (response.totalLength != (long)receivedMessage.size() && response.totalLength != 0L);
            response.response = receivedMessage.toString();
            return response;
        }

        public void reply(String out) throws TimeoutException, IOException, JSONException {
            int len;
            byte[] outputBytes = out == null ? new byte[]{} : out.getBytes();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintWriter outputWriter = new PrintWriter(outputStream);
            JSONObject headerJSON = new JSONObject().put(CoolSocket.HEADER_ITEM_LENGTH, outputBytes.length);
            outputWriter.write(headerJSON.toString() + CoolSocket.HEADER_SEPARATOR);
            outputWriter.flush();
            byte[] buffer = new byte[8096];
            long calculatedTimeout = this.getTimeout() != -1L ? System.currentTimeMillis() + this.getTimeout() : -1L;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputBytes);
            DataOutputStream remoteOutputStream = new DataOutputStream(this.getSocket().getOutputStream());
            remoteOutputStream.write(outputStream.toByteArray());
            remoteOutputStream.flush();
            do {
                if ((len = inputStream.read(buffer)) > 0) {
                    remoteOutputStream.write(buffer, 0, len);
                }
                if (calculatedTimeout == -1L || System.currentTimeMillis() <= calculatedTimeout) continue;
                throw new TimeoutException("Read timed out!");
            } while (len != -1);
        }

        public void setId(int id) {
            this.mId = id;
        }

        public void setTimeout(int timeout) {
            this.mTimeout = timeout;
        }

        public class Response {
            public SocketAddress remoteAddress;
            public JSONObject headerIndex;
            public String response;
            public long totalLength = -1L;
        }
    }
}

