/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.CoolSocket;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class CoolTransfer<T> {
    public static final int DELAY_DISABLED = -1;
    private final ArrayList<TransferHandler<T>> mProcess = new ArrayList();
    private ExecutorService mExecutor;
    private int mNotifyDelay = -1;
    private Object mBlockingObject = new Object();

    public abstract Flag onError(TransferHandler<T> var1, Exception var2);

    public abstract void onNotify(TransferHandler<T> var1, int var2);

    public abstract void onTransferCompleted(TransferHandler<T> var1);

    public abstract void onInterrupted(TransferHandler<T> var1);

    public abstract Flag onSocketReady(TransferHandler<T> var1);

    public abstract Flag onStart(TransferHandler<T> var1);

    public Flag onCloseStreams(TransferHandler<T> handler) {
        return Flag.CONTINUE;
    }

    public void onPrepareNext(TransferHandler<T> handler) {
    }

    public void onStop(TransferHandler<T> handler) {
    }

    public void onOrientatingStreams(TransferHandler<T> handler, InputStream inputStream, OutputStream outputStream) {
    }

    public void onProcessListChanged(ArrayList<TransferHandler<T>> processList, TransferHandler<T> handler, boolean isAdded) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProcess(TransferHandler<T> processHandler) {
        ArrayList<TransferHandler<T>> arrayList = this.getProcessList();
        synchronized (arrayList) {
            this.getProcessList().add(processHandler);
            this.onProcessListChanged(this.getProcessList(), processHandler, true);
        }
    }

    public Object getBlockingObject() {
        return this.mBlockingObject;
    }

    public ExecutorService getExecutor() {
        if (this.mExecutor == null) {
            this.mExecutor = Executors.newFixedThreadPool(10);
        }
        return this.mExecutor;
    }

    public int getNotifyDelay() {
        return this.mNotifyDelay;
    }

    public ArrayList<TransferHandler<T>> getProcessList() {
        return this.mProcess;
    }

    public void setBlockingObject(Object blockingObject) {
        this.mBlockingObject = blockingObject;
    }

    public void setExecutor(ExecutorService executor) {
        this.mExecutor = executor;
    }

    public void setNotifyDelay(int delay) {
        this.mNotifyDelay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProcess(TransferHandler<T> processHandler) {
        ArrayList<TransferHandler<T>> arrayList = this.getProcessList();
        synchronized (arrayList) {
            this.getProcessList().remove(processHandler);
            this.onProcessListChanged(this.getProcessList(), processHandler, false);
        }
    }

    public static class TransferProgress<T> {
        private long mStartTime = System.currentTimeMillis();
        private long mCurrentTransferredByte;
        private long mTransferredByte;
        private long mTotalByte;
        private long mTimeElapsed;
        private long mTimePassed;
        private long mTimeRemaining;
        private long mLastNotified;
        private int mTransferredFileCount;
        private boolean mInterrupted = false;

        public int calculatePercentage(long max, long current) {
            return (int)(100.0f / (float)max * (float)current);
        }

        public long decrementTransferredByte(long size) {
            this.mCurrentTransferredByte -= size;
            this.mTransferredByte -= size;
            return this.mTransferredByte;
        }

        public int decrementTransferredFileCount() {
            --this.mTransferredFileCount;
            return this.mTransferredFileCount;
        }

        public boolean doNotify(CoolTransfer<T> transfer, TransferHandler<T> handler) {
            if (transfer.getNotifyDelay() != -1 && System.currentTimeMillis() - this.getLastNotified() < (long)transfer.getNotifyDelay()) {
                return false;
            }
            int percentage = this.calculatePercentage(this.getTotalByte(), this.getTransferredByte());
            this.setTimeElapsed(System.currentTimeMillis() - this.getStartTime());
            if (this.getTotalByte() > 0L && this.getTransferredByte() > 0L) {
                this.setTimePassed(this.getTimeElapsed() * this.getTotalByte() / this.getTransferredByte());
                this.setTimeRemaining(this.getTimePassed() - this.getTimeElapsed());
            }
            transfer.onNotify(handler, percentage);
            this.mLastNotified = System.currentTimeMillis();
            return true;
        }

        public long getCurrentTransferredByte() {
            return this.mCurrentTransferredByte;
        }

        public long getLastNotified() {
            return this.mLastNotified;
        }

        public long getStartTime() {
            return this.mStartTime;
        }

        public long getTimeElapsed() {
            return this.mTimeElapsed;
        }

        public long getTimePassed() {
            return this.mTimePassed;
        }

        public long getTimeRemaining() {
            return this.mTimeRemaining;
        }

        public long getTotalByte() {
            return this.mTotalByte;
        }

        public int getTransferredFileCount() {
            return this.mTransferredFileCount;
        }

        public long getTransferredByte() {
            return this.mTransferredByte;
        }

        public long incrementTransferredByte(long size) {
            this.mCurrentTransferredByte += size;
            this.mTransferredByte += size;
            return this.mTransferredByte;
        }

        public int incrementTransferredFileCount() {
            ++this.mTransferredFileCount;
            return this.mTransferredFileCount;
        }

        public void interrupt() {
            this.mInterrupted = true;
        }

        public boolean isInterrupted() {
            return this.mInterrupted;
        }

        public void resetCurrentTransferredByte() {
            this.mCurrentTransferredByte = 0L;
        }

        public void setTotalByte(long totalByte) {
            this.mTotalByte = totalByte;
        }

        public void setTransferredByte(long transferredByte) {
            this.mTransferredByte = transferredByte;
        }

        public void setTransferredFileCount(int transferredFileCount) {
            this.mTransferredFileCount = transferredFileCount;
        }

        public void setStartTime(long startTime) {
            this.mStartTime = startTime;
        }

        public void setTimeElapsed(long timeElapsed) {
            this.mTimeElapsed = timeElapsed;
        }

        public void setTimePassed(long timePassed) {
            this.mTimePassed = timePassed;
        }

        public void setTimeRemaining(long timeRemaining) {
            this.mTimeRemaining = timeRemaining;
        }
    }

    public static abstract class Send<T>
    extends CoolTransfer<T> {
        public Handler send(String serverIp, int port, InputStream stream, long totalByte, int bufferSize, T extra, boolean currentThread) {
            Handler handler = new Handler(serverIp, port, stream, totalByte, new byte[bufferSize], extra);
            if (currentThread) {
                handler.run();
            } else {
                this.getExecutor().submit(handler);
            }
            return handler;
        }

        public Handler send(String serverIp, int port, File file, long totalByte, int bufferSize, T extra, boolean currentThread) throws FileNotFoundException {
            return this.send(serverIp, port, new FileInputStream(file), totalByte, bufferSize, extra, currentThread);
        }

        public class Handler
        extends TransferHandler<T> {
            private String mServerIp;
            private InputStream mStream;

            public Handler(String serverIp, int port, InputStream stream, long fileSize, byte[] bufferSize, T extra) {
                super(port, fileSize, bufferSize, extra);
                this.mServerIp = serverIp;
                this.mStream = stream;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onRun() {
                block21: {
                    Send.this.addProcess(this);
                    this.setFlag(Send.this.onStart(this));
                    try {
                        if (!Flag.CONTINUE.equals((Object)this.getFlag())) break block21;
                        this.setSocket(new Socket());
                        this.getSocket().bind(null);
                        this.getSocket().connect(new InetSocketAddress(this.getServerIp(), this.getPort()));
                        this.setFlag(Send.this.onSocketReady(this));
                        if (Flag.CONTINUE.equals((Object)this.getFlag())) {
                            OutputStream outputStream = this.getSocket().getOutputStream();
                            int len = 0;
                            Send.this.onOrientatingStreams(this, this.getInputStream(), outputStream);
                            this.getTransferProgress().resetCurrentTransferredByte();
                            this.getTransferProgress().incrementTransferredByte(this.getSkippedBytes());
                            while (len != -1) {
                                Object object = Send.this.getBlockingObject();
                                synchronized (object) {
                                    len = this.getInputStream().read(this.getBuffer());
                                    if (len > 0) {
                                        outputStream.write(this.getBuffer(), 0, len);
                                        outputStream.flush();
                                        this.getTransferProgress().incrementTransferredByte(len);
                                    }
                                }
                                this.getTransferProgress().doNotify(Send.this, this);
                                if (!this.isInterrupted()) continue;
                            }
                            outputStream.close();
                            this.getInputStream().close();
                        }
                        if (this.isInterrupted()) {
                            this.setFlag(Flag.CANCEL_ALL);
                            Send.this.onInterrupted(this);
                        } else {
                            this.getTransferProgress().incrementTransferredFileCount();
                            Send.this.onTransferCompleted(this);
                        }
                    }
                    catch (Exception e) {
                        this.setFlag(Send.this.onError(this, e));
                    }
                    finally {
                        try {
                            if (this.getSocket() != null && !this.getSocket().isClosed()) {
                                this.getSocket().close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        Send.this.onStop(this);
                        if (!Flag.CANCEL_ALL.equals((Object)this.getFlag())) {
                            Send.this.onPrepareNext(this);
                        }
                        Send.this.removeProcess(this);
                    }
                }
            }

            public InputStream getInputStream() {
                return this.mStream;
            }

            public String getServerIp() {
                return this.mServerIp;
            }

            @Override
            public void skipBytes(long bytes) throws IOException {
                super.skipBytes(bytes);
                this.getInputStream().skip(bytes);
            }
        }
    }

    public static abstract class Receive<T>
    extends CoolTransfer<T> {
        public abstract Flag onSocketReady(TransferHandler<T> var1, ServerSocket var2);

        public Handler receive(int port, File file, long fileSize, int bufferSize, int timeOut, T extra, boolean currentThread) throws FileNotFoundException {
            return this.receive(port, new FileOutputStream(file, true), fileSize, bufferSize, timeOut, extra, currentThread);
        }

        public Handler receive(int port, OutputStream outputStream, long fileSize, int bufferSize, int timeOut, T extra, boolean currentThread) {
            Handler handler = new Handler(extra, port, outputStream, fileSize, new byte[bufferSize], timeOut);
            if (currentThread) {
                handler.run();
            } else {
                this.getExecutor().submit(handler);
            }
            return handler;
        }

        public class Handler
        extends TransferHandler<T> {
            private int mTimeout;
            private OutputStream mStream;
            private ServerSocket mServerSocket;

            public Handler(T extra, int port, OutputStream stream, long fileSize, byte[] bufferSize, int timeout) {
                super(port, fileSize, bufferSize, extra);
                this.mStream = stream;
                this.mTimeout = timeout;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onRun() {
                block32: {
                    Receive.this.addProcess(this);
                    this.setFlag(Receive.this.onStart(this));
                    try {
                        if (!Flag.CONTINUE.equals((Object)this.getFlag())) break block32;
                        this.setServerSocket(new ServerSocket(this.getPort()));
                        if (this.getTimeout() != -1) {
                            this.getServerSocket().setSoTimeout(this.getTimeout());
                        }
                        this.setFlag(Receive.this.onSocketReady(this, this.getServerSocket()));
                        if (Flag.CONTINUE.equals((Object)this.getFlag())) {
                            this.setSocket(this.getServerSocket().accept());
                            if (this.getTimeout() != -1) {
                                this.getSocket().setSoTimeout(this.getTimeout());
                            }
                            this.setFlag(Receive.this.onSocketReady(this));
                            if (Flag.CONTINUE.equals((Object)this.getFlag())) {
                                InputStream inputStream = this.getSocket().getInputStream();
                                int len = 0;
                                long lastRead = System.currentTimeMillis();
                                Receive.this.onOrientatingStreams(this, inputStream, this.getOutputStream());
                                this.getTransferProgress().resetCurrentTransferredByte();
                                while (len != -1) {
                                    Object object = Receive.this.getBlockingObject();
                                    synchronized (object) {
                                        len = inputStream.read(this.getBuffer());
                                        if (len > 0) {
                                            this.getOutputStream().write(this.getBuffer(), 0, len);
                                            this.getOutputStream().flush();
                                            lastRead = System.currentTimeMillis();
                                            this.getTransferProgress().incrementTransferredByte(len);
                                        }
                                    }
                                    this.getTransferProgress().doNotify(Receive.this, this);
                                    if ((this.mTimeout <= 0 || System.currentTimeMillis() - lastRead <= (long)this.mTimeout) && !this.isInterrupted()) continue;
                                    System.out.println("CoolTransfer: Timed out... Exiting.");
                                    break;
                                }
                                this.getOutputStream().close();
                                inputStream.close();
                                this.setFlag(Receive.this.onCloseStreams(this));
                            }
                        }
                        if (!Flag.CANCEL_CURRENT.equals((Object)this.getFlag())) {
                            if (this.isInterrupted()) {
                                this.setFlag(Flag.CANCEL_ALL);
                                Receive.this.onInterrupted(this);
                            } else {
                                this.getTransferProgress().incrementTransferredFileCount();
                                Receive.this.onTransferCompleted(this);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.setFlag(Receive.this.onError(this, e));
                    }
                    finally {
                        try {
                            if (this.getSocket() != null && !this.getSocket().isClosed()) {
                                this.getSocket().close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            if (this.getServerSocket() != null && !this.getServerSocket().isClosed()) {
                                this.getServerSocket().close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        Receive.this.onStop(this);
                        if (!Flag.CANCEL_ALL.equals((Object)this.getFlag())) {
                            Receive.this.onPrepareNext(this);
                        }
                        Receive.this.removeProcess(this);
                    }
                }
            }

            public OutputStream getOutputStream() {
                return this.mStream;
            }

            public ServerSocket getServerSocket() {
                return this.mServerSocket;
            }

            public int getTimeout() {
                return this.mTimeout;
            }

            public void setServerSocket(ServerSocket serverSocket) {
                this.mServerSocket = serverSocket;
            }

            @Override
            public void skipBytes(long bytes) throws IOException {
                super.skipBytes(bytes);
            }
        }
    }

    public static abstract class TransferHandler<T>
    implements Runnable {
        private Socket mSocket;
        private TransferProgress<T> mTransferProgress;
        private Status mStatus = Status.PENDING;
        private Flag mFlag = Flag.CANCEL_ALL;
        private T mExtra;
        private int mPort;
        private long mFileSize;
        private byte[] mBuffer;
        private long mSkippedBytes = 0L;

        public TransferHandler(int port, long fileSize, byte[] bufferSize, T extra) {
            this.mExtra = extra;
            this.mPort = port;
            this.mFileSize = fileSize;
            this.mBuffer = bufferSize;
        }

        protected abstract void onRun();

        public void interrupt() {
            this.getTransferProgress().interrupt();
        }

        public boolean isInterrupted() {
            return this.getTransferProgress().isInterrupted();
        }

        public byte[] getBuffer() {
            return this.mBuffer;
        }

        public Flag getFlag() {
            return this.mFlag;
        }

        public long getFileSize() {
            return this.mFileSize;
        }

        public T getExtra() {
            return this.mExtra;
        }

        public int getPort() {
            return this.mPort;
        }

        public long getSkippedBytes() {
            return this.mSkippedBytes;
        }

        public Socket getSocket() {
            return this.mSocket;
        }

        public Status getStatus() {
            return this.mStatus;
        }

        public TransferProgress<T> getTransferProgress() {
            if (this.mTransferProgress == null) {
                this.mTransferProgress = new TransferProgress();
            }
            return this.mTransferProgress;
        }

        public TransferHandler<T> linkTo(TransferHandler<T> transferHandler) {
            if (transferHandler != null) {
                this.setTransferProgress(transferHandler.getTransferProgress());
            }
            return this;
        }

        public void setFlag(Flag flag) {
            this.mFlag = flag;
        }

        protected void setSocket(Socket socket) {
            this.mSocket = socket;
        }

        public void setStatus(Status status) {
            this.mStatus = status;
        }

        public void setTransferProgress(TransferProgress<T> transferProgress) {
            this.mTransferProgress = transferProgress;
        }

        public void skipBytes(long bytes) throws IOException {
            if (this.mSkippedBytes > 0L) {
                this.getTransferProgress().decrementTransferredByte(this.mSkippedBytes);
            }
            this.mSkippedBytes = bytes;
            this.getTransferProgress().incrementTransferredByte(this.mSkippedBytes);
        }

        @Override
        public void run() {
            this.setStatus(Status.RUNNING);
            this.onRun();
            this.setStatus(Status.INTERRUPTED);
        }
    }

    public static enum Status {
        INTERRUPTED,
        RUNNING,
        PENDING;

    }

    public static enum Flag {
        CONTINUE,
        CANCEL_ALL,
        CANCEL_CURRENT;

    }
}

