package com.realm.annotations;

import java.io.Serializable;

/**
  *
  *<b>The Base class to create a database table class with all required fields by the system.</b>
 * @author Edward Thompson
  **/

public class RealmModel implements Cloneable, Serializable {


    @DynamicProperty(column_name = "_id", json_key ="lid", column_data_type = "INTEGER",extra_params = "PRIMARY KEY AUTOINCREMENT")
    public String id;

    @DynamicProperty(json_key = "id", column_name = "sid", indexed_column = true,extra_params = "UNIQUE")
    public String sid;

    @DynamicProperty(json_key = "local_insert_time", column_data_type = "DATETIME", column_default_value = "(datetime('now','localtime'))")
    public String reg_time;

 @DynamicProperty(json_key = "server_update_time")
    public String srt;

    @DynamicProperty(json_key = "sync_status")
    public String sync_status= com.realm.annotations.sync_status.pending.ordinal()+"";

    @DynamicProperty(json_key = "is_active")
    public String data_status;

    @DynamicProperty(json_key = "transaction_no")
    public String transaction_no;

    @DynamicProperty(json_key = "datecomparer")
    public String sync_var;

    @DynamicProperty(json_key = "user_id")
    public String user_id;

    @DynamicProperty(column_name = "data_usage_frequency")
    public String data_usage_frequency="";

   @DynamicProperty(json_key = "device_code")
   public String device_code;





   public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    }
