/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization;

import com.github.agcom.bson.serialization.BsonConfiguration;
import com.github.agcom.bson.serialization.BsonDecodingException;
import com.github.agcom.bson.serialization.BsonKt;
import com.github.agcom.bson.serialization.decoders.BsonTreeInputKt;
import com.github.agcom.bson.serialization.encoders.TreeBsonOutputKt;
import com.github.agcom.bson.serialization.streaming.InputKt;
import com.github.agcom.bson.serialization.streaming.OutputKt;
import java.io.Closeable;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.PolymorphicKind;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StructureKind;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.modules.EmptyModule;
import kotlinx.serialization.modules.SerialModule;
import kotlinx.serialization.modules.SerialModuleExtensionsKt;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonInput;
import org.bson.io.BsonOutput;
import org.bson.io.ByteBufferBsonInput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\r0\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\r0\u00142\u0006\u0010\u0019\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u001aJ/\u0010\u0018\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\r0\u00142\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ'\u0010\u001e\u001a\u00020\u0016\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lcom/github/agcom/bson/serialization/Bson;", "Lkotlinx/serialization/BinaryFormat;", "configuration", "Lcom/github/agcom/bson/serialization/BsonConfiguration;", "context", "Lkotlinx/serialization/modules/SerialModule;", "(Lcom/github/agcom/bson/serialization/BsonConfiguration;Lkotlinx/serialization/modules/SerialModule;)V", "getConfiguration", "()Lcom/github/agcom/bson/serialization/BsonConfiguration;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "dump", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "fromBson", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bson", "Lorg/bson/BsonValue;", "(Lkotlinx/serialization/DeserializationStrategy;Lorg/bson/BsonValue;)Ljava/lang/Object;", "load", "bytes", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "type", "Lorg/bson/BsonType;", "(Lkotlinx/serialization/DeserializationStrategy;[BLorg/bson/BsonType;)Ljava/lang/Object;", "toBson", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lorg/bson/BsonValue;", "serialization"})
public final class Bson
implements BinaryFormat {
    @NotNull
    private final SerialModule context;
    @NotNull
    private final BsonConfiguration configuration;

    @NotNull
    public SerialModule getContext() {
        return this.context;
    }

    @NotNull
    public final <T> BsonValue toBson(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        return TreeBsonOutputKt.writeBson(this, value, serializer);
    }

    public final <T> T fromBson(@NotNull DeserializationStrategy<T> deserializer, @NotNull BsonValue bson) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        Intrinsics.checkParameterIsNotNull((Object)bson, (String)"bson");
        return BsonTreeInputKt.readBson(this, bson, deserializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T> byte[] dump(@NotNull SerializationStrategy<? super T> serializer, T value) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        BsonValue bson = this.toBson(serializer, value);
        Closeable closeable = (Closeable)new BasicOutputBuffer();
        boolean bl = false;
        Throwable throwable = null;
        try {
            BasicOutputBuffer it = (BasicOutputBuffer)closeable;
            boolean bl2 = false;
            OutputKt.writeBson((BsonOutput)it, bson);
            byte[] byArray2 = it.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"it.toByteArray()");
            byArray = byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BasicOutputBuffer().use \u2026t.toByteArray()\n        }");
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T load(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes) {
        BsonType bsonType;
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        SerialKind serialKind = deserializer.getDescriptor().getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            bsonType = BsonType.ARRAY;
        } else if (serialKind instanceof StructureKind) {
            bsonType = BsonType.DOCUMENT;
        } else {
            if (!(serialKind instanceof PolymorphicKind)) throw (Throwable)((Object)new BsonDecodingException("Unable to infer the bytes bson type\nSupply the bson type using load(deserializer, bytes, type) function if you're sure about the bytes bson type, else this is a bug and is filed for fix"));
            if (!(deserializer instanceof AbstractPolymorphicSerializer)) throw (Throwable)((Object)new BsonDecodingException("Unable to infer the bytes bson type\nSupply the bson type using load(deserializer, bytes, type) function if you're sure about the bytes bson type, else this is a bug and is filed for fix"));
            bsonType = BsonType.DOCUMENT;
        }
        BsonType type = bsonType;
        return this.load(deserializer, bytes, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T load(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes, @NotNull BsonType type) {
        BsonValue bsonValue;
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Closeable closeable = (Closeable)new ByteBufferBsonInput((ByteBuf)new ByteBufNIO(ByteBuffer.wrap(bytes)));
        boolean bl = false;
        Throwable throwable = null;
        try {
            ByteBufferBsonInput it = (ByteBufferBsonInput)closeable;
            boolean bl2 = false;
            bsonValue = InputKt.readBson((BsonInput)it, type);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        BsonValue bson = bsonValue;
        return this.fromBson(deserializer, bson);
    }

    @NotNull
    public final BsonConfiguration getConfiguration() {
        return this.configuration;
    }

    public Bson(@NotNull BsonConfiguration configuration, @NotNull SerialModule context) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.configuration = configuration;
        this.context = SerialModuleExtensionsKt.plus((SerialModule)context, (SerialModule)BsonKt.access$getDefaultBsonModule$p());
    }

    public /* synthetic */ Bson(BsonConfiguration bsonConfiguration, SerialModule serialModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bsonConfiguration = BsonConfiguration.Companion.getSTABLE();
        }
        if ((n & 2) != 0) {
            serialModule = (SerialModule)EmptyModule.INSTANCE;
        }
        this(bsonConfiguration, serialModule);
    }

    public Bson() {
        this(null, null, 3, null);
    }
}

