/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.decoders;

import com.github.agcom.bson.serialization.Bson;
import com.github.agcom.bson.serialization.BsonDecodingException;
import com.github.agcom.bson.serialization.decoders.AbstractBsonTreeInput;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorKt;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/github/agcom/bson/serialization/decoders/BsonTreeInput;", "Lcom/github/agcom/bson/serialization/decoders/AbstractBsonTreeInput;", "bson", "Lcom/github/agcom/bson/serialization/Bson;", "value", "Lorg/bson/BsonDocument;", "(Lcom/github/agcom/bson/serialization/Bson;Lorg/bson/BsonDocument;)V", "position", "", "getValue", "()Lorg/bson/BsonDocument;", "currentElement", "Lorg/bson/BsonValue;", "tag", "", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "endStructure", "", "serialization"})
class BsonTreeInput
extends AbstractBsonTreeInput {
    private int position;
    @NotNull
    private final BsonDocument value;

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        while (this.position < descriptor.getElementsCount()) {
            int n = this.position;
            this.position = n + 1;
            String name = this.getTag(descriptor, n);
            Map map = (Map)this.getValue();
            boolean bl = false;
            Map map2 = map;
            boolean bl2 = false;
            if (!map2.containsKey(name)) continue;
            return this.position - 1;
        }
        return -1;
    }

    @Override
    @NotNull
    protected BsonValue currentElement(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Object object = MapsKt.getValue((Map)((Map)this.getValue()), (Object)tag);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"value.getValue(tag)");
        return (BsonValue)object;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        if (!this.getBson().getConfiguration().getIgnoreUnknownKeys()) {
            List names = SerialDescriptorKt.elementNames((SerialDescriptor)descriptor);
            for (String key : this.getValue().keySet()) {
                if (names.contains(key)) continue;
                throw (Throwable)((Object)new BsonDecodingException("Unknown key '" + key + '\''));
            }
        }
    }

    @NotNull
    public BsonDocument getValue() {
        return this.value;
    }

    public BsonTreeInput(@NotNull Bson bson, @NotNull BsonDocument value) {
        Intrinsics.checkParameterIsNotNull((Object)bson, (String)"bson");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        super(bson, (BsonValue)value, null);
        this.value = value;
    }
}

