/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.decoders;

import com.github.agcom.bson.serialization.Bson;
import com.github.agcom.bson.serialization.BsonDecodingException;
import com.github.agcom.bson.serialization.decoders.AbstractBsonTreeInput;
import com.github.agcom.bson.serialization.decoders.BsonPrimitiveInput;
import com.github.agcom.bson.serialization.decoders.BsonTreeInput;
import com.github.agcom.bson.serialization.decoders.BsonTreeInputKt$WhenMappings;
import com.github.agcom.bson.serialization.decoders.BsonTreeListInput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.DecodingKt;
import kotlinx.serialization.DeserializationStrategy;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a-\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"readBson", "T", "Lcom/github/agcom/bson/serialization/Bson;", "element", "Lorg/bson/BsonValue;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lcom/github/agcom/bson/serialization/Bson;Lorg/bson/BsonValue;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "serialization"})
public final class BsonTreeInputKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <T> T readBson(@NotNull Bson $this$readBson, @NotNull BsonValue element, @NotNull DeserializationStrategy<T> deserializer) {
        AbstractBsonTreeInput abstractBsonTreeInput;
        Intrinsics.checkParameterIsNotNull((Object)$this$readBson, (String)"$this$readBson");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        BsonType bsonType = element.getBsonType();
        if (bsonType == null) throw (Throwable)((Object)new BsonDecodingException("Unexpected bson type '" + element.getBsonType() + '\''));
        switch (BsonTreeInputKt$WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                abstractBsonTreeInput = new BsonPrimitiveInput($this$readBson, element);
                break;
            }
            case 13: {
                BsonDocument bsonDocument = element.asDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonDocument, (String)"element.asDocument()");
                abstractBsonTreeInput = new BsonTreeInput($this$readBson, bsonDocument);
                break;
            }
            case 14: {
                BsonArray bsonArray = element.asArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonArray, (String)"element.asArray()");
                abstractBsonTreeInput = new BsonTreeListInput($this$readBson, bsonArray);
                break;
            }
            default: {
                throw (Throwable)((Object)new BsonDecodingException("Unexpected bson type '" + element.getBsonType() + '\''));
            }
        }
        AbstractBsonTreeInput input = abstractBsonTreeInput;
        return (T)DecodingKt.decode((Decoder)input, deserializer);
    }
}

