/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.encoders;

import com.github.agcom.bson.serialization.Bson;
import com.github.agcom.bson.serialization.BsonEncodingException;
import com.github.agcom.bson.serialization.encoders.BsonTreeMapOutput$WhenMappings;
import com.github.agcom.bson.serialization.encoders.BsonTreeOutput;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerialDescriptor;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/agcom/bson/serialization/encoders/BsonTreeMapOutput;", "Lcom/github/agcom/bson/serialization/encoders/BsonTreeOutput;", "bson", "Lcom/github/agcom/bson/serialization/Bson;", "nodeConsumer", "Lkotlin/Function1;", "Lorg/bson/BsonValue;", "", "(Lcom/github/agcom/bson/serialization/Bson;Lkotlin/jvm/functions/Function1;)V", "isKey", "", "tag", "", "getCurrent", "putElement", "key", "element", "shouldWriteElement", "desc", "Lkotlinx/serialization/SerialDescriptor;", "index", "", "serialization"})
final class BsonTreeMapOutput
extends BsonTreeOutput {
    private String tag;
    private boolean isKey;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void putElement(@NotNull String key, @NotNull BsonValue element) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (this.isKey) {
            String string;
            BsonType bsonType = element.getBsonType();
            if (bsonType == null) throw (Throwable)((Object)new BsonEncodingException("Unexpected BsonType, type = '" + element.getBsonType() + '\''));
            switch (BsonTreeMapOutput$WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
                case 1: {
                    BsonDouble bsonDouble = element.asDouble();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonDouble, (String)"element.asDouble()");
                    string = String.valueOf(bsonDouble.getValue());
                    break;
                }
                case 2: {
                    BsonString bsonString = element.asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonString, (String)"element.asString()");
                    String string2 = bsonString.getValue();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.asString().value");
                    break;
                }
                case 3: {
                    BsonObjectId bsonObjectId = element.asObjectId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonObjectId, (String)"element.asObjectId()");
                    String string3 = bsonObjectId.getValue().toHexString();
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.asObjectId().value.toHexString()");
                    break;
                }
                case 4: {
                    BsonBoolean bsonBoolean = element.asBoolean();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonBoolean, (String)"element.asBoolean()");
                    string = String.valueOf(bsonBoolean.getValue());
                    break;
                }
                case 5: {
                    BsonDateTime bsonDateTime = element.asDateTime();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonDateTime, (String)"element.asDateTime()");
                    string = String.valueOf(bsonDateTime.getValue());
                    break;
                }
                case 6: {
                    string = "null";
                    break;
                }
                case 7: {
                    BsonRegularExpression bsonRegularExpression = element.asRegularExpression();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonRegularExpression, (String)"element.asRegularExpression()");
                    String string4 = bsonRegularExpression.getPattern();
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"element.asRegularExpression().pattern");
                    break;
                }
                case 8: {
                    BsonJavaScript bsonJavaScript = element.asJavaScript();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonJavaScript, (String)"element.asJavaScript()");
                    String string5 = bsonJavaScript.getCode();
                    string = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"element.asJavaScript().code");
                    break;
                }
                case 9: {
                    BsonInt32 bsonInt32 = element.asInt32();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonInt32, (String)"element.asInt32()");
                    string = String.valueOf(bsonInt32.getValue());
                    break;
                }
                case 10: {
                    BsonInt64 bsonInt64 = element.asInt64();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonInt64, (String)"element.asInt64()");
                    string = String.valueOf(bsonInt64.getValue());
                    break;
                }
                case 11: {
                    BsonDecimal128 bsonDecimal128 = element.asDecimal128();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonDecimal128, (String)"element.asDecimal128()");
                    String string6 = bsonDecimal128.getValue().toString();
                    string = string6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"element.asDecimal128().value.toString()");
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    throw (Throwable)((Object)new BsonEncodingException("Invalid key kind '" + element.getBsonType() + '\''));
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    throw (Throwable)((Object)new BsonEncodingException("Unexpected BsonType, type = '" + element.getBsonType() + '\''));
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.tag = string;
            this.isKey = false;
            return;
        } else {
            String string = this.tag;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tag");
            }
            super.putElement(string, element);
            this.isKey = true;
        }
    }

    @Override
    @NotNull
    public BsonValue getCurrent() {
        return (BsonValue)this.getContent();
    }

    public boolean shouldWriteElement(@NotNull SerialDescriptor desc, @NotNull String tag, int index) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        return true;
    }

    public BsonTreeMapOutput(@NotNull Bson bson, @NotNull Function1<? super BsonValue, Unit> nodeConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)bson, (String)"bson");
        Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
        super(bson, nodeConsumer);
        this.isKey = true;
    }
}

