/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.BsonEncodingException;
import com.github.agcom.bson.serialization.decoders.BsonInput;
import com.github.agcom.bson.serialization.encoders.BsonOutput;
import com.github.agcom.bson.serialization.serializers.BsonPrimitiveSerializer$WhenMappings;
import com.github.agcom.bson.serialization.serializers.VerifyKt;
import com.github.agcom.bson.serialization.utils.BinaryKt;
import com.github.agcom.bson.serialization.utils.RegexKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PrimitiveKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorBuilderKt;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.Serializer;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;

@Serializer(forClass=BsonValue.class)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/github/agcom/bson/serialization/serializers/BsonPrimitiveSerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/bson/BsonValue;", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "serialization"})
public final class BsonPrimitiveSerializer
implements KSerializer<BsonValue> {
    @NotNull
    private static final SerialDescriptor descriptor;
    public static final BsonPrimitiveSerializer INSTANCE;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(@NotNull Encoder encoder2, @NotNull BsonValue value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        VerifyKt.verify(encoder2);
        BsonOutput cfr_ignored_0 = (BsonOutput)encoder2;
        BsonType bsonType = value.getBsonType();
        if (bsonType == null) throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + value.getBsonType() + '\''));
        switch (BsonPrimitiveSerializer$WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
            case 1: {
                BsonDouble bsonDouble = value.asDouble();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonDouble, (String)"value.asDouble()");
                encoder2.encodeDouble(bsonDouble.getValue());
                return;
            }
            case 2: {
                BsonString bsonString = value.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonString, (String)"value.asString()");
                String string = bsonString.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.asString().value");
                encoder2.encodeString(string);
                return;
            }
            case 3: {
                BsonOutput bsonOutput = (BsonOutput)encoder2;
                BsonBinary bsonBinary = value.asBinary();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonBinary, (String)"value.asBinary()");
                bsonOutput.encodeBinary(BinaryKt.toBinary(bsonBinary));
                return;
            }
            case 4: {
                BsonOutput bsonOutput = (BsonOutput)encoder2;
                BsonObjectId bsonObjectId = value.asObjectId();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonObjectId, (String)"value.asObjectId()");
                ObjectId objectId = bsonObjectId.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectId, (String)"value.asObjectId().value");
                bsonOutput.encodeObjectId(objectId);
                return;
            }
            case 5: {
                BsonBoolean bsonBoolean = value.asBoolean();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonBoolean, (String)"value.asBoolean()");
                encoder2.encodeBoolean(bsonBoolean.getValue());
                return;
            }
            case 6: {
                BsonOutput bsonOutput = (BsonOutput)encoder2;
                BsonDateTime bsonDateTime = value.asDateTime();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonDateTime, (String)"value.asDateTime()");
                bsonOutput.encodeDateTime(bsonDateTime.getValue());
                return;
            }
            case 7: {
                encoder2.encodeNull();
                return;
            }
            case 8: {
                BsonOutput bsonOutput = (BsonOutput)encoder2;
                BsonJavaScript bsonJavaScript = value.asJavaScript();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonJavaScript, (String)"value.asJavaScript()");
                String string = bsonJavaScript.getCode();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.asJavaScript().code");
                bsonOutput.encodeJavaScript(string);
                return;
            }
            case 9: {
                BsonInt32 bsonInt32 = value.asInt32();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonInt32, (String)"value.asInt32()");
                encoder2.encodeInt(bsonInt32.getValue());
                return;
            }
            case 10: {
                BsonInt64 bsonInt64 = value.asInt64();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonInt64, (String)"value.asInt64()");
                encoder2.encodeLong(bsonInt64.getValue());
                return;
            }
            case 11: {
                BsonOutput bsonOutput = (BsonOutput)encoder2;
                BsonDecimal128 bsonDecimal128 = value.asDecimal128();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonDecimal128, (String)"value.asDecimal128()");
                Decimal128 decimal128 = bsonDecimal128.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)decimal128, (String)"value.asDecimal128().value");
                bsonOutput.encodeDecimal128(decimal128);
                return;
            }
            case 12: {
                BsonOutput bsonOutput = (BsonOutput)encoder2;
                BsonRegularExpression bsonRegularExpression = value.asRegularExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonRegularExpression, (String)"value.asRegularExpression()");
                bsonOutput.encodeRegularExpression(RegexKt.toRegex(bsonRegularExpression));
                return;
            }
            default: {
                throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + value.getBsonType() + '\''));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public BsonValue deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        VerifyKt.verify(decoder);
        BsonInput cfr_ignored_0 = (BsonInput)decoder;
        BsonValue value = ((BsonInput)decoder).decodeBson();
        BsonType bsonType = value.getBsonType();
        if (bsonType == null) throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + value.getBsonType() + '\''));
        switch (BsonPrimitiveSerializer$WhenMappings.$EnumSwitchMapping$1[bsonType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + value.getBsonType() + '\''));
            }
        }
        return value;
    }

    private BsonPrimitiveSerializer() {
    }

    static {
        BsonPrimitiveSerializer bsonPrimitiveSerializer;
        INSTANCE = bsonPrimitiveSerializer = new BsonPrimitiveSerializer();
        String string = Reflection.getOrCreateKotlinClass(BsonValue.class).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        descriptor = SerialDescriptorBuilderKt.SerialDescriptor$default((String)string, (SerialKind)((SerialKind)PrimitiveKind.STRING.INSTANCE), null, (int)4, null);
    }

    @NotNull
    public BsonValue patch(@NotNull Decoder decoder, @NotNull BsonValue old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return (BsonValue)KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, (Object)old);
    }
}

