/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.BsonEncodingException;
import com.github.agcom.bson.serialization.decoders.BsonInput;
import com.github.agcom.bson.serialization.serializers.BsonArraySerializer;
import com.github.agcom.bson.serialization.serializers.BsonDocumentSerializer;
import com.github.agcom.bson.serialization.serializers.BsonPrimitiveSerializer;
import com.github.agcom.bson.serialization.serializers.BsonValueSerializer$WhenMappings;
import com.github.agcom.bson.serialization.serializers.VerifyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.EncodingKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorBuilderKt;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Serializer;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.jetbrains.annotations.NotNull;

@Serializer(forClass=BsonValue.class)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/github/agcom/bson/serialization/serializers/BsonValueSerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/bson/BsonValue;", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "serialization"})
public final class BsonValueSerializer
implements KSerializer<BsonValue> {
    @NotNull
    private static final SerialDescriptor descriptor;
    public static final BsonValueSerializer INSTANCE;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(@NotNull Encoder encoder2, @NotNull BsonValue value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        VerifyKt.verify(encoder2);
        BsonType bsonType = value.getBsonType();
        if (bsonType == null) throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + value.getBsonType() + '\''));
        switch (BsonValueSerializer$WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)BsonPrimitiveSerializer.INSTANCE), (Object)value);
                return;
            }
            case 15: {
                EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)BsonDocumentSerializer.INSTANCE), (Object)value.asDocument());
                return;
            }
            case 16: {
                EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)BsonArraySerializer.INSTANCE), (Object)value.asArray());
                return;
            }
            default: {
                throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + value.getBsonType() + '\''));
            }
        }
    }

    @NotNull
    public BsonValue deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        VerifyKt.verify(decoder);
        BsonInput cfr_ignored_0 = (BsonInput)decoder;
        return ((BsonInput)decoder).decodeBson();
    }

    private BsonValueSerializer() {
    }

    static {
        BsonValueSerializer bsonValueSerializer;
        INSTANCE = bsonValueSerializer = new BsonValueSerializer();
        String string = Reflection.getOrCreateKotlinClass(BsonValue.class).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        descriptor = SerialDescriptorBuilderKt.SerialDescriptor$default((String)string, (SerialKind)((SerialKind)PolymorphicKind.SEALED.INSTANCE), null, (int)4, null);
    }

    @NotNull
    public BsonValue patch(@NotNull Decoder decoder, @NotNull BsonValue old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return (BsonValue)KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, (Object)old);
    }
}

