/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.serializers.LocalDateTimeSerializer;
import com.github.agcom.bson.serialization.serializers.TemporalSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/github/agcom/bson/serialization/serializers/LocalTimeSerializer;", "Lcom/github/agcom/bson/serialization/serializers/TemporalSerializer;", "Ljava/time/LocalTime;", "()V", "ofEpochMillis", "temporal", "", "toEpochMillis", "serialization"})
public final class LocalTimeSerializer
extends TemporalSerializer<LocalTime> {
    public static final LocalTimeSerializer INSTANCE;

    @Override
    public long toEpochMillis(@NotNull LocalTime temporal) {
        Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
        LocalDateTime localDateTime = temporal.atDate(LocalDate.now());
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"temporal.atDate(LocalDate.now())");
        return LocalDateTimeSerializer.INSTANCE.toEpochMillis(localDateTime);
    }

    @Override
    @NotNull
    public LocalTime ofEpochMillis(long temporal) {
        LocalTime localTime = LocalDateTimeSerializer.INSTANCE.ofEpochMillis(temporal).toLocalTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"LocalDateTimeSerializer.\u2026s(temporal).toLocalTime()");
        return localTime;
    }

    private LocalTimeSerializer() {
        String string = Reflection.getOrCreateKotlinClass(LocalTime.class).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        super(string);
    }

    static {
        LocalTimeSerializer localTimeSerializer;
        INSTANCE = localTimeSerializer = new LocalTimeSerializer();
    }
}

