/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.serializers.OffsetDateTimeSerializer;
import com.github.agcom.bson.serialization.serializers.TemporalSerializer;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/github/agcom/bson/serialization/serializers/OffsetTimeSerializer;", "Lcom/github/agcom/bson/serialization/serializers/TemporalSerializer;", "Ljava/time/OffsetTime;", "()V", "ofEpochMillis", "temporal", "", "toEpochMillis", "serialization"})
public final class OffsetTimeSerializer
extends TemporalSerializer<OffsetTime> {
    public static final OffsetTimeSerializer INSTANCE;

    @Override
    public long toEpochMillis(@NotNull OffsetTime temporal) {
        Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
        OffsetDateTime offsetDateTime = temporal.atDate(LocalDate.now());
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime, (String)"temporal.atDate(LocalDate.now())");
        return OffsetDateTimeSerializer.INSTANCE.toEpochMillis(offsetDateTime);
    }

    @Override
    @NotNull
    public OffsetTime ofEpochMillis(long temporal) {
        OffsetTime offsetTime = OffsetDateTimeSerializer.INSTANCE.ofEpochMillis(temporal).toOffsetTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetTime, (String)"OffsetDateTimeSerializer\u2026(temporal).toOffsetTime()");
        return offsetTime;
    }

    private OffsetTimeSerializer() {
        String string = Reflection.getOrCreateKotlinClass(OffsetTime.class).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        super(string);
    }

    static {
        OffsetTimeSerializer offsetTimeSerializer;
        INSTANCE = offsetTimeSerializer = new OffsetTimeSerializer();
    }
}

