/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.serializers.DateTimeSerializer;
import com.github.agcom.bson.serialization.serializers.InstantSerializer;
import com.github.agcom.bson.serialization.serializers.LocalDateSerializer;
import com.github.agcom.bson.serialization.serializers.LocalDateTimeSerializer;
import com.github.agcom.bson.serialization.serializers.LocalTimeSerializer;
import com.github.agcom.bson.serialization.serializers.OffsetTimeSerializer;
import com.github.agcom.bson.serialization.serializers.ZonedDateTimeSerializer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.DecodingKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.EncodingKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PrimitiveKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorBuilderKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Serializer;
import org.jetbrains.annotations.NotNull;

@Serializer(forClass=Temporal.class)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000 \u001b*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/github/agcom/bson/serialization/serializers/TemporalSerializer;", "T", "Ljava/time/temporal/Temporal;", "Lkotlinx/serialization/KSerializer;", "serialName", "", "(Ljava/lang/String;)V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "(Lkotlinx/serialization/Decoder;)Ljava/time/temporal/Temporal;", "ofEpochMillis", "temporal", "", "(J)Ljava/time/temporal/Temporal;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "(Lkotlinx/serialization/Encoder;Ljava/time/temporal/Temporal;)V", "toEpochMillis", "(Ljava/time/temporal/Temporal;)J", "Companion", "serialization"})
public abstract class TemporalSerializer<T extends Temporal>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)DateTimeSerializer.INSTANCE), (Object)this.toEpochMillis(value));
    }

    @NotNull
    public final T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        return this.ofEpochMillis(((Number)DecodingKt.decode((Decoder)decoder, (DeserializationStrategy)((DeserializationStrategy)DateTimeSerializer.INSTANCE))).longValue());
    }

    public abstract long toEpochMillis(@NotNull T var1);

    @NotNull
    public abstract T ofEpochMillis(long var1);

    public TemporalSerializer(@NotNull String serialName) {
        Intrinsics.checkParameterIsNotNull((Object)serialName, (String)"serialName");
        this.descriptor = SerialDescriptorBuilderKt.PrimitiveDescriptor((String)serialName, (PrimitiveKind)((PrimitiveKind)PrimitiveKind.LONG.INSTANCE));
    }

    @NotNull
    public T patch(@NotNull Decoder decoder, @NotNull T old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull(old, (String)"old");
        return (T)((Temporal)KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, old));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/github/agcom/bson/serialization/serializers/TemporalSerializer$Companion;", "Lcom/github/agcom/bson/serialization/serializers/TemporalSerializer;", "Ljava/time/temporal/Temporal;", "()V", "ofEpochMillis", "temporal", "", "toEpochMillis", "serialization"})
    public static final class Companion
    extends TemporalSerializer<Temporal> {
        @Override
        public long toEpochMillis(@NotNull Temporal temporal) {
            long l;
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            Temporal temporal2 = temporal;
            if (temporal2 instanceof Instant) {
                l = InstantSerializer.INSTANCE.toEpochMillis((Instant)temporal);
            } else if (temporal2 instanceof LocalDateTime) {
                l = LocalDateTimeSerializer.INSTANCE.toEpochMillis((LocalDateTime)temporal);
            } else if (temporal2 instanceof LocalDate) {
                l = LocalDateSerializer.INSTANCE.toEpochMillis((LocalDate)temporal);
            } else if (temporal2 instanceof LocalTime) {
                l = LocalTimeSerializer.INSTANCE.toEpochMillis((LocalTime)temporal);
            } else if (temporal2 instanceof OffsetTime) {
                l = OffsetTimeSerializer.INSTANCE.toEpochMillis((OffsetTime)temporal);
            } else if (temporal2 instanceof ZonedDateTime) {
                l = ZonedDateTimeSerializer.INSTANCE.toEpochMillis((ZonedDateTime)temporal);
            } else {
                throw (Throwable)new IllegalArgumentException("Unsupported temporal class '" + temporal.getClass().getName() + '\'');
            }
            return l;
        }

        @Override
        @NotNull
        public Temporal ofEpochMillis(long temporal) {
            Instant instant = Instant.ofEpochMilli(temporal);
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochMilli(temporal)");
            return instant;
        }

        private Companion() {
            String string = Reflection.getOrCreateKotlinClass(Temporal.class).getQualifiedName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            super(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

