/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.serializers.InstantSerializer;
import com.github.agcom.bson.serialization.serializers.TemporalSerializer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/github/agcom/bson/serialization/serializers/ZonedDateTimeSerializer;", "Lcom/github/agcom/bson/serialization/serializers/TemporalSerializer;", "Ljava/time/ZonedDateTime;", "()V", "ofEpochMillis", "temporal", "", "toEpochMillis", "serialization"})
public final class ZonedDateTimeSerializer
extends TemporalSerializer<ZonedDateTime> {
    public static final ZonedDateTimeSerializer INSTANCE;

    @Override
    public long toEpochMillis(@NotNull ZonedDateTime temporal) {
        Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
        Instant instant = temporal.toInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"temporal.toInstant()");
        return InstantSerializer.INSTANCE.toEpochMillis(instant);
    }

    @Override
    @NotNull
    public ZonedDateTime ofEpochMillis(long temporal) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(InstantSerializer.INSTANCE.ofEpochMillis(temporal), ZoneOffset.UTC);
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.ofInstant(\u2026emporal), ZoneOffset.UTC)");
        return zonedDateTime;
    }

    private ZonedDateTimeSerializer() {
        String string = Reflection.getOrCreateKotlinClass(ZonedDateTime.class).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        super(string);
    }

    static {
        ZonedDateTimeSerializer zonedDateTimeSerializer;
        INSTANCE = zonedDateTimeSerializer = new ZonedDateTimeSerializer();
    }
}

