/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.streaming;

import com.github.agcom.bson.serialization.BsonDecodingException;
import com.github.agcom.bson.serialization.streaming.InputKt$WhenMappings;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinarySubType;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.io.BsonInput;
import org.bson.types.Decimal128;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0002H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"readArray", "Lorg/bson/BsonArray;", "Lorg/bson/io/BsonInput;", "readBson", "Lorg/bson/BsonValue;", "type", "Lorg/bson/BsonType;", "readDocument", "Lorg/bson/BsonDocument;", "readPrimitive", "serialization"})
public final class InputKt {
    @NotNull
    public static final BsonValue readBson(@NotNull BsonInput $this$readBson, @NotNull BsonType type) {
        BsonValue bsonValue;
        Intrinsics.checkParameterIsNotNull((Object)$this$readBson, (String)"$this$readBson");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        switch (InputKt$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                bsonValue = InputKt.readPrimitive($this$readBson, type);
                break;
            }
            case 13: {
                bsonValue = (BsonValue)InputKt.readDocument($this$readBson);
                break;
            }
            case 14: {
                bsonValue = (BsonValue)InputKt.readArray($this$readBson);
                break;
            }
            default: {
                throw (Throwable)((Object)new BsonDecodingException("Unexpected bson type '" + type + '\''));
            }
        }
        return bsonValue;
    }

    private static final BsonValue readPrimitive(@NotNull BsonInput $this$readPrimitive, BsonType type) {
        BsonValue bsonValue;
        switch (InputKt$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                bsonValue = (BsonValue)new BsonDouble($this$readPrimitive.readDouble());
                break;
            }
            case 2: {
                bsonValue = (BsonValue)new BsonString($this$readPrimitive.readString());
                break;
            }
            case 3: {
                int size = $this$readPrimitive.readInt32();
                if (size < 0) {
                    throw (Throwable)((Object)new BsonDecodingException("Invalid binary data size '" + size + '\''));
                }
                byte binaryType = $this$readPrimitive.readByte();
                if (binaryType == BsonBinarySubType.OLD_BINARY.getValue()) {
                    int repeatedSize = $this$readPrimitive.readInt32();
                    if (repeatedSize != size - 4) {
                        throw (Throwable)((Object)new BsonDecodingException("Binary sub type OldBinary has inconsistent sizes"));
                    }
                    size -= 4;
                }
                byte[] bytes = new byte[size];
                $this$readPrimitive.readBytes(bytes);
                bsonValue = (BsonValue)new BsonBinary(binaryType, bytes);
                break;
            }
            case 4: {
                bsonValue = (BsonValue)new BsonObjectId($this$readPrimitive.readObjectId());
                break;
            }
            case 5: {
                boolean bl;
                switch ($this$readPrimitive.readByte()) {
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 0: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw (Throwable)((Object)new BsonDecodingException("Not a bson boolean"));
                    }
                }
                bsonValue = (BsonValue)new BsonBoolean(bl);
                break;
            }
            case 6: {
                bsonValue = (BsonValue)new BsonDateTime($this$readPrimitive.readInt64());
                break;
            }
            case 7: {
                BsonNull bsonNull = BsonNull.VALUE;
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonNull, (String)"BsonNull.VALUE");
                bsonValue = (BsonValue)bsonNull;
                break;
            }
            case 8: {
                bsonValue = (BsonValue)new BsonRegularExpression($this$readPrimitive.readCString(), $this$readPrimitive.readCString());
                break;
            }
            case 9: {
                bsonValue = (BsonValue)new BsonJavaScript($this$readPrimitive.readString());
                break;
            }
            case 10: {
                bsonValue = (BsonValue)new BsonInt32($this$readPrimitive.readInt32());
                break;
            }
            case 11: {
                bsonValue = (BsonValue)new BsonInt64($this$readPrimitive.readInt64());
                break;
            }
            case 12: {
                long low = $this$readPrimitive.readInt64();
                long high = $this$readPrimitive.readInt64();
                return (BsonValue)new BsonDecimal128(Decimal128.fromIEEE754BIDEncoding((long)high, (long)low));
            }
            default: {
                throw (Throwable)((Object)new BsonDecodingException("Unexpected bson type '" + type + '\''));
            }
        }
        BsonValue value = bsonValue;
        if ($this$readPrimitive.hasRemaining()) {
            throw (Throwable)((Object)new BsonDecodingException("Not a '" + type + "' bson primitive"));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BsonDocument readDocument(@NotNull BsonInput $this$readDocument) {
        BsonDocument doc = new BsonDocument();
        BsonBinaryReader reader = new BsonBinaryReader($this$readDocument);
        Closeable closeable = (Closeable)new BsonDocumentWriter(doc);
        boolean bl = false;
        Throwable throwable = null;
        try {
            BsonDocumentWriter writer = (BsonDocumentWriter)closeable;
            boolean bl2 = false;
            Closeable closeable2 = (Closeable)reader;
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                BsonBinaryReader it = (BsonBinaryReader)closeable2;
                boolean bl4 = false;
                writer.pipe((BsonReader)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return doc;
    }

    /*
     * WARNING - void declaration
     */
    private static final BsonArray readArray(@NotNull BsonInput $this$readArray) {
        BsonDocument doc = InputKt.readDocument($this$readArray);
        BsonArray arr = new BsonArray();
        int counter = 0;
        Map $this$forEach$iv = (Map)doc;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry element$iv;
            Map.Entry $dstr$key$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$key$value;
            int n = 0;
            String string = (String)entry.getKey();
            entry = $dstr$key$value;
            n = 0;
            BsonValue value = (BsonValue)entry.getValue();
            void v0 = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"key");
            Integer n2 = StringsKt.toIntOrNull((String)v0);
            if (n2 == null) {
                throw (Throwable)((Object)new BsonDecodingException("Not a bson array"));
            }
            int index = n2;
            n = counter;
            counter = n + 1;
            if (index != n) {
                throw (Throwable)((Object)new BsonDecodingException("Not a bson array"));
            }
            arr.add(value);
        }
        return arr;
    }
}

