/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.streaming;

import com.github.agcom.bson.serialization.BsonEncodingException;
import com.github.agcom.bson.serialization.streaming.OutputKt$WhenMappings;
import java.io.Closeable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.io.BsonOutput;
import org.bson.types.Decimal128;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"writeArray", "", "Lorg/bson/io/BsonOutput;", "array", "Lorg/bson/BsonArray;", "writeBson", "bson", "Lorg/bson/BsonValue;", "writeDocument", "doc", "Lorg/bson/BsonDocument;", "writePrimitive", "serialization"})
public final class OutputKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void writeBson(@NotNull BsonOutput $this$writeBson, @NotNull BsonValue bson) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeBson, (String)"$this$writeBson");
        Intrinsics.checkParameterIsNotNull((Object)bson, (String)"bson");
        BsonType bsonType = bson.getBsonType();
        if (bsonType == null) throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + bson.getBsonType() + '\''));
        switch (OutputKt$WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                OutputKt.writePrimitive($this$writeBson, bson);
                return;
            }
            case 13: {
                BsonDocument bsonDocument = bson.asDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonDocument, (String)"bson.asDocument()");
                OutputKt.writeDocument($this$writeBson, bsonDocument);
                return;
            }
            case 14: {
                BsonArray bsonArray = bson.asArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonArray, (String)"bson.asArray()");
                OutputKt.writeArray($this$writeBson, bsonArray);
                return;
            }
            default: {
                throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + bson.getBsonType() + '\''));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void writePrimitive(@NotNull BsonOutput $this$writePrimitive, BsonValue bson) {
        BsonType bsonType = bson.getBsonType();
        if (bsonType == null) throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + bson.getBsonType() + '\''));
        switch (OutputKt$WhenMappings.$EnumSwitchMapping$1[bsonType.ordinal()]) {
            case 1: {
                BsonDouble bsonDouble = bson.asDouble();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonDouble, (String)"bson.asDouble()");
                $this$writePrimitive.writeDouble(bsonDouble.getValue());
                return;
            }
            case 2: {
                BsonString bsonString = bson.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonString, (String)"bson.asString()");
                $this$writePrimitive.writeString(bsonString.getValue());
                return;
            }
            case 3: {
                bson.asBinary();
                BsonValue bsonValue = bson;
                if (bsonValue == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonBinary");
                }
                BsonBinary cfr_ignored_0 = (BsonBinary)bsonValue;
                int totalLen = ((BsonBinary)bson).getData().length;
                if (((BsonBinary)bson).getType() == BsonBinarySubType.OLD_BINARY.getValue()) {
                    totalLen += 4;
                }
                $this$writePrimitive.writeInt32(totalLen);
                $this$writePrimitive.writeByte((int)((BsonBinary)bson).getType());
                if (((BsonBinary)bson).getType() == BsonBinarySubType.OLD_BINARY.getValue()) {
                    $this$writePrimitive.writeInt32(totalLen - 4);
                }
                $this$writePrimitive.writeBytes(((BsonBinary)bson).getData());
                return;
            }
            case 4: {
                BsonObjectId bsonObjectId = bson.asObjectId();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonObjectId, (String)"bson.asObjectId()");
                $this$writePrimitive.writeObjectId(bsonObjectId.getValue());
                return;
            }
            case 5: {
                BsonBoolean bsonBoolean = bson.asBoolean();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonBoolean, (String)"bson.asBoolean()");
                $this$writePrimitive.writeByte(bsonBoolean.getValue() ? 1 : 0);
                return;
            }
            case 6: {
                BsonDateTime bsonDateTime = bson.asDateTime();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonDateTime, (String)"bson.asDateTime()");
                $this$writePrimitive.writeInt64(bsonDateTime.getValue());
                return;
            }
            case 7: {
                return;
            }
            case 8: {
                bson.asRegularExpression();
                BsonValue bsonValue = bson;
                if (bsonValue == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonRegularExpression");
                }
                BsonRegularExpression cfr_ignored_1 = (BsonRegularExpression)bsonValue;
                $this$writePrimitive.writeCString(((BsonRegularExpression)bson).getPattern());
                $this$writePrimitive.writeCString(((BsonRegularExpression)bson).getOptions());
                return;
            }
            case 9: {
                BsonJavaScript bsonJavaScript = bson.asJavaScript();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonJavaScript, (String)"bson.asJavaScript()");
                $this$writePrimitive.writeString(bsonJavaScript.getCode());
                return;
            }
            case 10: {
                BsonInt32 bsonInt32 = bson.asInt32();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonInt32, (String)"bson.asInt32()");
                $this$writePrimitive.writeInt32(bsonInt32.getValue());
                return;
            }
            case 11: {
                BsonInt64 bsonInt64 = bson.asInt64();
                Intrinsics.checkExpressionValueIsNotNull((Object)bsonInt64, (String)"bson.asInt64()");
                $this$writePrimitive.writeInt64(bsonInt64.getValue());
                return;
            }
            case 12: {
                bson.asDecimal128();
                BsonValue bsonValue = bson;
                if (bsonValue == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonDecimal128");
                }
                BsonDecimal128 cfr_ignored_2 = (BsonDecimal128)bsonValue;
                Decimal128 decimal128 = ((BsonDecimal128)bson).getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)decimal128, (String)"bson.value");
                $this$writePrimitive.writeInt64(decimal128.getLow());
                Decimal128 decimal1282 = ((BsonDecimal128)bson).getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)decimal1282, (String)"bson.value");
                $this$writePrimitive.writeInt64(decimal1282.getHigh());
                return;
            }
            default: {
                throw (Throwable)((Object)new BsonEncodingException("Unexpected bson type '" + bson.getBsonType() + '\''));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeDocument(@NotNull BsonOutput $this$writeDocument, BsonDocument doc) {
        BsonBinaryWriter writer = new BsonBinaryWriter($this$writeDocument);
        Closeable closeable = (Closeable)new BsonDocumentReader(doc);
        boolean bl = false;
        Throwable throwable = null;
        try {
            BsonDocumentReader reader = (BsonDocumentReader)closeable;
            boolean bl2 = false;
            Closeable closeable2 = (Closeable)writer;
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                BsonBinaryWriter it = (BsonBinaryWriter)closeable2;
                boolean bl4 = false;
                it.pipe((BsonReader)reader);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeArray(@NotNull BsonOutput $this$writeArray, BsonArray array) {
        BsonDocument doc = new BsonDocument();
        Iterable $this$forEachIndexed$iv = (Iterable)array;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            BsonValue bsonValue = (BsonValue)item$iv;
            int i = n2;
            boolean bl2 = false;
            ((Map)doc).put(String.valueOf(i), value);
        }
        OutputKt.writeDocument($this$writeArray, doc);
    }
}

