/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.encoders;

import com.github.agcom.bson.serialization.Bson;
import com.github.agcom.bson.serialization.BsonEncodingException;
import com.github.agcom.bson.serialization.encoders.BsonOutput;
import com.github.agcom.bson.serialization.encoders.BsonPrimitiveOutput;
import com.github.agcom.bson.serialization.encoders.BsonTreeListOutput;
import com.github.agcom.bson.serialization.encoders.BsonTreeMapOutput;
import com.github.agcom.bson.serialization.encoders.BsonTreeOutput;
import com.github.agcom.bson.serialization.serializers.BsonValueSerializer;
import com.github.agcom.bson.serialization.utils.BsonRegularExpressionKt;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.EncodingKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicKind;
import kotlinx.serialization.PrimitiveKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorKt;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StructureKind;
import kotlinx.serialization.UnionKind;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.NamedValueEncoder;
import kotlinx.serialization.modules.SerialModule;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ1\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u001a\u0010\u0018\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019\"\u0006\u0012\u0002\b\u00030\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020 H\u0016J\u0010\u00100\u001a\u00020\b2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\b2\u0006\u00104\u001a\u000205H\u0016J)\u00106\u001a\u00020\b\"\u0004\b\u0000\u001072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H70\u001e2\u0006\u00108\u001a\u0002H7H\u0016\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020%H\u0002J\u0018\u0010<\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020\u0013H\u0016J\u0018\u0010=\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020\u0007H\u0002J\u0018\u0010>\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020?H\u0016J\u0018\u0010@\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020*H\u0002J\u0018\u0010C\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020-H\u0002J\u0018\u0010D\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020EH\u0016J \u0010F\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u0010G\u001a\u00020\u00172\u0006\u0010H\u001a\u00020IH\u0016J\u0018\u0010J\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020KH\u0016J\u0018\u0010L\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020IH\u0016J\u0018\u0010M\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J\u0018\u0010N\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020*H\u0016J\u0010\u0010O\u001a\u00020\b2\u0006\u0010;\u001a\u00020 H\u0016J\u0018\u0010P\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u000202H\u0002J\u0018\u0010Q\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u000205H\u0002J\u0018\u0010R\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020SH\u0016J\u0018\u0010T\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0016J\u0018\u0010U\u001a\u00020\b2\u0006\u0010;\u001a\u00020 2\u0006\u00108\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010X\u001a\u00020\u0007H&J\u0018\u0010Y\u001a\u00020\b2\u0006\u0010Z\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0007H&J\u0018\u0010[\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\\\u001a\u00020IH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003]^_\u00a8\u0006`"}, d2={"Lcom/github/agcom/bson/serialization/encoders/AbstractBsonTreeOutput;", "Lkotlinx/serialization/internal/NamedValueEncoder;", "Lcom/github/agcom/bson/serialization/encoders/BsonOutput;", "bson", "Lcom/github/agcom/bson/serialization/Bson;", "nodeConsumer", "Lkotlin/Function1;", "Lorg/bson/BsonValue;", "", "(Lcom/github/agcom/bson/serialization/Bson;Lkotlin/jvm/functions/Function1;)V", "getBson", "()Lcom/github/agcom/bson/serialization/Bson;", "context", "Lkotlinx/serialization/modules/SerialModule;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "getNodeConsumer", "()Lkotlin/jvm/functions/Function1;", "writePolymorphic", "", "beginStructure", "Lkotlinx/serialization/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "typeSerializers", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeEncoder;", "checkClassDiscriminatorConflict", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "composeName", "", "parentName", "childName", "encodeBinary", "binary", "Lorg/bson/types/Binary;", "encodeBson", "element", "encodeDateTime", "time", "", "encodeDecimal128", "decimal", "Lorg/bson/types/Decimal128;", "encodeJavaScript", "code", "encodeObjectId", "objectId", "Lorg/bson/types/ObjectId;", "encodeRegularExpression", "pattern", "Ljava/util/regex/Pattern;", "encodeSerializableValue", "T", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeTaggedBinary", "tag", "encodeTaggedBoolean", "encodeTaggedBson", "encodeTaggedByte", "", "encodeTaggedChar", "", "encodeTaggedDateTime", "encodeTaggedDecimal128", "encodeTaggedDouble", "", "encodeTaggedEnum", "enumDescription", "ordinal", "", "encodeTaggedFloat", "", "encodeTaggedInt", "encodeTaggedJavaScript", "encodeTaggedLong", "encodeTaggedNull", "encodeTaggedObjectId", "encodeTaggedRegularExpression", "encodeTaggedShort", "", "encodeTaggedString", "encodeTaggedValue", "", "endEncode", "getCurrent", "putElement", "key", "shouldEncodeElementDefault", "index", "Lcom/github/agcom/bson/serialization/encoders/BsonPrimitiveOutput;", "Lcom/github/agcom/bson/serialization/encoders/BsonTreeOutput;", "Lcom/github/agcom/bson/serialization/encoders/BsonTreeListOutput;", "serialization"})
abstract class AbstractBsonTreeOutput
extends NamedValueEncoder
implements BsonOutput {
    private boolean writePolymorphic;
    @NotNull
    private final Bson bson;
    @NotNull
    private final Function1<BsonValue, Unit> nodeConsumer;

    @NotNull
    public final SerialModule getContext() {
        return this.bson.getContext();
    }

    @Override
    public void encodeBson(@NotNull BsonValue element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.encodeSerializableValue((SerializationStrategy)BsonValueSerializer.INSTANCE, element);
    }

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        return this.bson.getConfiguration().getEncodeDefaults();
    }

    @NotNull
    public String composeName(@NotNull String parentName, @NotNull String childName) {
        Intrinsics.checkParameterIsNotNull((Object)parentName, (String)"parentName");
        Intrinsics.checkParameterIsNotNull((Object)childName, (String)"childName");
        return childName;
    }

    public void encodeTaggedNull(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        BsonNull bsonNull = BsonNull.VALUE;
        Intrinsics.checkExpressionValueIsNotNull((Object)bsonNull, (String)"BsonNull.VALUE");
        this.putElement(tag, (BsonValue)bsonNull);
    }

    public void encodeTaggedInt(@NotNull String tag, int value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.putElement(tag, (BsonValue)new BsonInt32(value));
    }

    public void encodeTaggedByte(@NotNull String tag, byte value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.encodeTaggedInt(tag, (int)value);
    }

    public void encodeTaggedShort(@NotNull String tag, short value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.encodeTaggedInt(tag, (int)value);
    }

    public void encodeTaggedLong(@NotNull String tag, long value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.putElement(tag, (BsonValue)new BsonInt64(value));
    }

    public void encodeTaggedFloat(@NotNull String tag, float value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.encodeTaggedDouble(tag, (double)value);
    }

    public void encodeTaggedDouble(@NotNull String tag, double value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.putElement(tag, (BsonValue)new BsonDouble(value));
    }

    public void encodeTaggedBoolean(@NotNull String tag, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.putElement(tag, (BsonValue)new BsonBoolean(value));
    }

    public void encodeTaggedString(@NotNull String tag, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.putElement(tag, (BsonValue)new BsonString(value));
    }

    public void encodeTaggedChar(@NotNull String tag, char value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.encodeTaggedString(tag, String.valueOf(value));
    }

    public void encodeTaggedEnum(@NotNull String tag, @NotNull SerialDescriptor enumDescription, int ordinal) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)enumDescription, (String)"enumDescription");
        this.encodeTaggedString(tag, enumDescription.getElementName(ordinal));
    }

    public void encodeTaggedValue(@NotNull String tag, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.encodeTaggedString(tag, value.toString());
    }

    private final void encodeTaggedBinary(String tag, Binary value) {
        this.putElement(tag, (BsonValue)new BsonBinary(value.getType(), value.getData()));
    }

    private final void encodeTaggedObjectId(String tag, ObjectId value) {
        this.putElement(tag, (BsonValue)new BsonObjectId(value));
    }

    private final void encodeTaggedDateTime(String tag, long value) {
        this.putElement(tag, (BsonValue)new BsonDateTime(value));
    }

    private final void encodeTaggedJavaScript(String tag, String value) {
        this.putElement(tag, (BsonValue)new BsonJavaScript(value));
    }

    private final void encodeTaggedDecimal128(String tag, Decimal128 value) {
        this.putElement(tag, (BsonValue)new BsonDecimal128(value));
    }

    private final void encodeTaggedRegularExpression(String tag, Pattern value) {
        this.putElement(tag, (BsonValue)BsonRegularExpressionKt.toBsonRegularExpression(value));
    }

    private final void encodeTaggedBson(String tag, BsonValue value) {
        this.putElement(tag, value);
    }

    @Override
    public void encodeBinary(@NotNull Binary binary) {
        Intrinsics.checkParameterIsNotNull((Object)binary, (String)"binary");
        this.encodeTaggedBinary((String)this.popTag(), binary);
    }

    @Override
    public void encodeObjectId(@NotNull ObjectId objectId) {
        Intrinsics.checkParameterIsNotNull((Object)objectId, (String)"objectId");
        this.encodeTaggedObjectId((String)this.popTag(), objectId);
    }

    @Override
    public void encodeDateTime(long time) {
        this.encodeTaggedDateTime((String)this.popTag(), time);
    }

    @Override
    public void encodeJavaScript(@NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        this.encodeTaggedJavaScript((String)this.popTag(), code);
    }

    @Override
    public void encodeDecimal128(@NotNull Decimal128 decimal) {
        Intrinsics.checkParameterIsNotNull((Object)decimal, (String)"decimal");
        this.encodeTaggedDecimal128((String)this.popTag(), decimal);
    }

    @Override
    public void encodeRegularExpression(@NotNull Pattern pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        this.encodeTaggedRegularExpression((String)this.popTag(), pattern);
    }

    private final void checkClassDiscriminatorConflict(SerializationStrategy<?> serializer) {
        if (SerialDescriptorKt.elementNames((SerialDescriptor)serializer.getDescriptor()).contains(this.bson.getConfiguration().getClassDiscriminator())) {
            throw (Throwable)((Object)new BsonEncodingException("Class discriminator '" + this.bson.getConfiguration().getClassDiscriminator() + "' conflict at " + serializer.getDescriptor().getSerialName()));
        }
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        if (this.getCurrentTagOrNull() != null || !(serializer.getDescriptor().getKind() instanceof PrimitiveKind) && serializer.getDescriptor().getKind() != UnionKind.ENUM_KIND.INSTANCE) {
            if (!(serializer instanceof AbstractPolymorphicSerializer)) {
                serializer.serialize((Encoder)this, value);
            } else {
                KSerializer kSerializer = ((AbstractPolymorphicSerializer)serializer).findPolymorphicSerializer((Encoder)this, value);
                if (kSerializer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
                }
                KSerializer actualSerializer = kSerializer;
                this.checkClassDiscriminatorConflict((SerializationStrategy)actualSerializer);
                if (actualSerializer.getDescriptor().getKind() instanceof PolymorphicKind) {
                    throw (Throwable)((Object)new BsonEncodingException("Actual serializer for polymorphic cannot be polymorphic itself"));
                }
                this.writePolymorphic = true;
                actualSerializer.serialize((Encoder)this, value);
            }
        } else {
            BsonPrimitiveOutput bsonPrimitiveOutput = new BsonPrimitiveOutput(this.bson, this.nodeConsumer);
            boolean bl = false;
            boolean bl2 = false;
            BsonPrimitiveOutput $this$apply = bsonPrimitiveOutput;
            boolean bl3 = false;
            EncodingKt.encode((Encoder)$this$apply, serializer, value);
            $this$apply.endEncode(serializer.getDescriptor());
        }
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor, KSerializer<?> ... typeSerializers) {
        AbstractBsonTreeOutput encoder2;
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(typeSerializers, (String)"typeSerializers");
        Function1 consumer2 = this.getCurrentTagOrNull() == null ? this.nodeConsumer : (Function1)new Function1<BsonValue, Unit>(this){
            final /* synthetic */ AbstractBsonTreeOutput this$0;

            public final void invoke(@NotNull BsonValue node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                this.this$0.putElement(AbstractBsonTreeOutput.access$getCurrentTag$p(this.this$0), node);
            }
            {
                this.this$0 = abstractBsonTreeOutput;
                super(1);
            }
        };
        SerialKind serialKind = descriptor.getKind();
        AbstractBsonTreeOutput abstractBsonTreeOutput = Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) ? (AbstractBsonTreeOutput)new BsonTreeListOutput(this.bson, (Function1<? super BsonValue, Unit>)consumer2) : (encoder2 = Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) ? (AbstractBsonTreeOutput)new BsonTreeMapOutput(this.bson, (Function1<? super BsonValue, Unit>)consumer2) : (AbstractBsonTreeOutput)new BsonTreeOutput(this.bson, (Function1<? super BsonValue, Unit>)consumer2));
        if (this.writePolymorphic) {
            this.writePolymorphic = false;
            encoder2.putElement(this.bson.getConfiguration().getClassDiscriminator(), (BsonValue)new BsonString(descriptor.getSerialName()));
        }
        return encoder2;
    }

    public void endEncode(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        this.nodeConsumer.invoke((Object)this.getCurrent());
    }

    public abstract void putElement(@NotNull String var1, @NotNull BsonValue var2);

    @NotNull
    public abstract BsonValue getCurrent();

    @Override
    @NotNull
    public final Bson getBson() {
        return this.bson;
    }

    @NotNull
    public final Function1<BsonValue, Unit> getNodeConsumer() {
        return this.nodeConsumer;
    }

    private AbstractBsonTreeOutput(Bson bson, Function1<? super BsonValue, Unit> nodeConsumer) {
        super(null, 1, null);
        this.bson = bson;
        this.nodeConsumer = nodeConsumer;
    }

    public /* synthetic */ AbstractBsonTreeOutput(Bson bson, Function1 nodeConsumer, DefaultConstructorMarker $constructor_marker) {
        this(bson, (Function1<? super BsonValue, Unit>)nodeConsumer);
    }

    public static final /* synthetic */ String access$getCurrentTag$p(AbstractBsonTreeOutput $this) {
        return (String)$this.getCurrentTag();
    }
}

