/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.decoders.BsonInput;
import com.github.agcom.bson.serialization.encoders.BsonOutput;
import com.github.agcom.bson.serialization.serializers.BsonDecimal128Serializer;
import com.github.agcom.bson.serialization.serializers.BsonDoubleSerializer;
import com.github.agcom.bson.serialization.serializers.BsonInt32Serializer;
import com.github.agcom.bson.serialization.serializers.BsonInt64Serializer;
import com.github.agcom.bson.serialization.serializers.BsonNumberSerializer$WhenMappings;
import com.github.agcom.bson.serialization.serializers.VerifyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.EncodingKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorBuilderKt;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationStrategy;
import org.bson.BsonNumber;
import org.bson.BsonType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/github/agcom/bson/serialization/serializers/BsonNumberSerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/bson/BsonNumber;", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "serialization"})
public final class BsonNumberSerializer
implements KSerializer<BsonNumber> {
    @NotNull
    private static final SerialDescriptor descriptor;
    public static final BsonNumberSerializer INSTANCE;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(@NotNull Encoder encoder2, @NotNull BsonNumber value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        VerifyKt.verify(encoder2);
        BsonOutput cfr_ignored_0 = (BsonOutput)encoder2;
        BsonType bsonType = value.getBsonType();
        if (bsonType == null) throw (Throwable)new RuntimeException("Should not reach here");
        switch (BsonNumberSerializer$WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
            case 1: {
                EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)BsonDoubleSerializer.INSTANCE), (Object)value.asDouble());
                return;
            }
            case 2: {
                EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)BsonInt32Serializer.INSTANCE), (Object)value.asInt32());
                return;
            }
            case 3: {
                EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)BsonInt64Serializer.INSTANCE), (Object)value.asInt64());
                return;
            }
            case 4: {
                EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)BsonDecimal128Serializer.INSTANCE), (Object)value.asDecimal128());
                return;
            }
            default: {
                throw (Throwable)new RuntimeException("Should not reach here");
            }
        }
    }

    @NotNull
    public BsonNumber deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        VerifyKt.verify(decoder);
        BsonInput cfr_ignored_0 = (BsonInput)decoder;
        BsonNumber bsonNumber = ((BsonInput)decoder).decodeBson().asNumber();
        Intrinsics.checkExpressionValueIsNotNull((Object)bsonNumber, (String)"decoder.decodeBson().asNumber()");
        return bsonNumber;
    }

    private BsonNumberSerializer() {
    }

    static {
        BsonNumberSerializer bsonNumberSerializer;
        INSTANCE = bsonNumberSerializer = new BsonNumberSerializer();
        String string = Reflection.getOrCreateKotlinClass(BsonNumber.class).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        descriptor = SerialDescriptorBuilderKt.SerialDescriptor$default((String)string, (SerialKind)((SerialKind)PolymorphicKind.SEALED.INSTANCE), null, (int)4, null);
    }

    @NotNull
    public BsonNumber patch(@NotNull Decoder decoder, @NotNull BsonNumber old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return (BsonNumber)KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, (Object)old);
    }
}

