/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.decoders;

import com.github.agcom.bson.serialization.Bson;
import com.github.agcom.bson.serialization.decoders.BsonTreeInput;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerialDescriptor;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/github/agcom/bson/serialization/decoders/BsonTreeMapInput;", "Lcom/github/agcom/bson/serialization/decoders/BsonTreeInput;", "bson", "Lcom/github/agcom/bson/serialization/Bson;", "value", "Lorg/bson/BsonDocument;", "(Lcom/github/agcom/bson/serialization/Bson;Lorg/bson/BsonDocument;)V", "keys", "", "", "kotlin.jvm.PlatformType", "position", "", "size", "getValue", "()Lorg/bson/BsonDocument;", "currentElement", "Lorg/bson/BsonValue;", "tag", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "elementName", "desc", "index", "endStructure", "", "serialization"})
final class BsonTreeMapInput
extends BsonTreeInput {
    private final List<String> keys;
    private final int size;
    private int position;
    @NotNull
    private final BsonDocument value;

    @NotNull
    public String elementName(@NotNull SerialDescriptor desc, int index) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        String string = this.keys.get(index / 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keys[index / 2]");
        return string;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        if (this.position < this.size - 1) {
            BsonTreeMapInput bsonTreeMapInput = this;
            ++bsonTreeMapInput.position;
            return bsonTreeMapInput.position;
        }
        return -1;
    }

    @Override
    @NotNull
    protected BsonValue currentElement(@NotNull String tag) {
        BsonValue bsonValue;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.position % 2 == 0) {
            bsonValue = (BsonValue)new BsonString(tag);
        } else {
            Object object = MapsKt.getValue((Map)((Map)this.getValue()), (Object)tag);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"value.getValue(tag)");
            bsonValue = (BsonValue)object;
        }
        return bsonValue;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
    }

    @Override
    @NotNull
    public BsonDocument getValue() {
        return this.value;
    }

    public BsonTreeMapInput(@NotNull Bson bson, @NotNull BsonDocument value) {
        Intrinsics.checkParameterIsNotNull((Object)bson, (String)"bson");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        super(bson, value);
        this.value = value;
        Set set = this.getValue().keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"value.keys");
        this.keys = CollectionsKt.toList((Iterable)set);
        this.size = this.keys.size() * 2;
        this.position = -1;
    }
}

