/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.serializers.BinarySerializer;
import com.github.agcom.bson.serialization.serializers.VerifyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.DecodingKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.EncodingKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import org.bson.BsonBinarySubType;
import org.bson.types.Binary;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/github/agcom/bson/serialization/serializers/ByteArraySerializer;", "Lkotlinx/serialization/KSerializer;", "", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "serialization"})
public final class ByteArraySerializer
implements KSerializer<byte[]> {
    @NotNull
    private static final SerialDescriptor descriptor;
    public static final ByteArraySerializer INSTANCE;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public void serialize(@NotNull Encoder encoder2, @NotNull byte[] value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        VerifyKt.verify(encoder2);
        EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)BinarySerializer.INSTANCE), (Object)new Binary(value));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        VerifyKt.verify(decoder);
        Binary binary = (Binary)DecodingKt.decode((Decoder)decoder, (DeserializationStrategy)((DeserializationStrategy)BinarySerializer.INSTANCE));
        if (binary.getType() != BsonBinarySubType.BINARY.getValue()) {
            String string;
            int n;
            int n2;
            StringBuilder stringBuilder;
            block3: {
                void $this$firstOrNull$iv;
                BsonBinarySubType[] bsonBinarySubTypeArray = BsonBinarySubType.values();
                stringBuilder = new StringBuilder().append("Expected bson binary type to be ").append(BsonBinarySubType.BINARY).append(", ").append("but was ");
                boolean $i$f$firstOrNull = false;
                void var5_7 = $this$firstOrNull$iv;
                n2 = ((void)var5_7).length;
                for (n = 0; n < n2; ++n) {
                    void element$iv;
                    void it = element$iv = var5_7[n];
                    boolean bl = false;
                    if (!(it.getValue() == binary.getType())) continue;
                    string = element$iv;
                    break block3;
                }
                string = null;
            }
            String string2 = string;
            StringBuilder stringBuilder2 = stringBuilder;
            String string3 = string2;
            if (string3 == null) {
                byte by = binary.getType();
                int n3 = 16;
                stringBuilder = stringBuilder2;
                boolean bl = false;
                n2 = by;
                n = CharsKt.checkRadix((int)n3);
                boolean bl2 = false;
                String string4 = Integer.toString(n2, CharsKt.checkRadix((int)n));
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                string2 = string4;
                stringBuilder2 = stringBuilder;
                string3 = string2;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n4 = 2;
            Throwable throwable = null;
            String string5 = stringBuilder2.append((Object)string3).toString();
            throw (Throwable)new SerializationException(string5, throwable, n4, defaultConstructorMarker);
        }
        byte[] byArray = binary.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"binary.data");
        return byArray;
    }

    private ByteArraySerializer() {
    }

    static {
        ByteArraySerializer byteArraySerializer;
        INSTANCE = byteArraySerializer = new ByteArraySerializer();
        descriptor = BinarySerializer.INSTANCE.getDescriptor();
    }

    @NotNull
    public byte[] patch(@NotNull Decoder decoder, @NotNull byte[] old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return (byte[])KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, (Object)old);
    }
}

