/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.serializers.BinarySerializer;
import com.github.agcom.bson.serialization.serializers.BsonBinarySerializer;
import com.github.agcom.bson.serialization.serializers.UUIDSerializer$WhenMappings;
import com.github.agcom.bson.serialization.serializers.VerifyKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.DecodingKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.EncodingKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerializationStrategy;
import org.bson.BsonBinarySubType;
import org.bson.UuidRepresentation;
import org.bson.internal.UuidHelper;
import org.bson.types.Binary;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/agcom/bson/serialization/serializers/UUIDSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/util/UUID;", "uuidRepresentation", "Lorg/bson/UuidRepresentation;", "(Lorg/bson/UuidRepresentation;)V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "serialization"})
public final class UUIDSerializer
implements KSerializer<UUID> {
    @NotNull
    private final SerialDescriptor descriptor;
    private final UuidRepresentation uuidRepresentation;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void serialize(@NotNull Encoder encoder2, @NotNull UUID value) {
        BsonBinarySubType bsonBinarySubType;
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        VerifyKt.verify(encoder2);
        switch (UUIDSerializer$WhenMappings.$EnumSwitchMapping$0[this.uuidRepresentation.ordinal()]) {
            case 1: {
                bsonBinarySubType = BsonBinarySubType.UUID_STANDARD;
                break;
            }
            default: {
                bsonBinarySubType = BsonBinarySubType.UUID_LEGACY;
            }
        }
        Binary binary = new Binary(bsonBinarySubType, UuidHelper.encodeUuidToBinary((UUID)value, (UuidRepresentation)this.uuidRepresentation));
        EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)BinarySerializer.INSTANCE), (Object)binary);
    }

    @NotNull
    public UUID deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        VerifyKt.verify(decoder);
        Binary binary = (Binary)DecodingKt.decode((Decoder)decoder, (DeserializationStrategy)((DeserializationStrategy)BinarySerializer.INSTANCE));
        UUID uUID = UuidHelper.decodeBinaryToUuid((byte[])binary.getData(), (byte)binary.getType(), (UuidRepresentation)this.uuidRepresentation);
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UuidHelper.decodeBinaryT\u2026type, uuidRepresentation)");
        return uUID;
    }

    public UUIDSerializer(@NotNull UuidRepresentation uuidRepresentation) {
        Intrinsics.checkParameterIsNotNull((Object)uuidRepresentation, (String)"uuidRepresentation");
        this.uuidRepresentation = uuidRepresentation;
        this.descriptor = BsonBinarySerializer.INSTANCE.getDescriptor();
    }

    public /* synthetic */ UUIDSerializer(UuidRepresentation uuidRepresentation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uuidRepresentation = UuidRepresentation.STANDARD;
        }
        this(uuidRepresentation);
    }

    public UUIDSerializer() {
        this(null, 1, null);
    }

    @NotNull
    public UUID patch(@NotNull Decoder decoder, @NotNull UUID old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        return (UUID)KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, (Object)old);
    }
}

