/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization;

import com.github.agcom.bson.serialization.BsonConfiguration;
import com.github.agcom.bson.serialization.BsonDecodingException;
import com.github.agcom.bson.serialization.BsonEncodingException;
import com.github.agcom.bson.serialization.BsonException;
import com.github.agcom.bson.serialization.BsonKt;
import com.github.agcom.bson.serialization.decoders.BsonTreeInputKt;
import com.github.agcom.bson.serialization.encoders.BsonTreeOutputKt;
import com.github.agcom.bson.serialization.utils.BsonStreamsKt;
import com.github.agcom.bson.serialization.utils.BsonValueKt;
import com.github.agcom.bson.serialization.utils.BsonValueKt$WhenMappings;
import java.io.Closeable;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.PolymorphicKind;
import kotlinx.serialization.PrimitiveKind;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StructureKind;
import kotlinx.serialization.UnionKind;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.modules.EmptyModule;
import kotlinx.serialization.modules.SerialModule;
import kotlinx.serialization.modules.SerialModuleExtensionsKt;
import org.bson.BSONException;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonInput;
import org.bson.io.BsonOutput;
import org.bson.io.ByteBufferBsonInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J'\u0010\u0017\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\r0\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ)\u0010\u001d\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\r0\u00192\u0006\u0010\u001e\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\fJ\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\fJ'\u0010\"\u001a\u00020\u001b\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\r\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/github/agcom/bson/serialization/Bson;", "Lkotlinx/serialization/BinaryFormat;", "configuration", "Lcom/github/agcom/bson/serialization/BsonConfiguration;", "context", "Lkotlinx/serialization/modules/SerialModule;", "(Lcom/github/agcom/bson/serialization/BsonConfiguration;Lkotlinx/serialization/modules/SerialModule;)V", "getConfiguration", "()Lcom/github/agcom/bson/serialization/BsonConfiguration;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "dump", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "dumpBson", "bsonArray", "Lorg/bson/BsonArray;", "bsonDocument", "Lorg/bson/BsonDocument;", "fromBson", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bsonValue", "Lorg/bson/BsonValue;", "(Lkotlinx/serialization/DeserializationStrategy;Lorg/bson/BsonValue;)Ljava/lang/Object;", "load", "bytes", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "loadBsonArray", "loadBsonDocument", "toBson", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lorg/bson/BsonValue;", "serialization"})
public final class Bson
implements BinaryFormat {
    @NotNull
    private final SerialModule context;
    @NotNull
    private final BsonConfiguration configuration;

    @NotNull
    public SerialModule getContext() {
        return this.context;
    }

    @NotNull
    public final <T> BsonValue toBson(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        return BsonTreeOutputKt.writeBson(this, value, serializer);
    }

    public final <T> T fromBson(@NotNull DeserializationStrategy<T> deserializer, @NotNull BsonValue bsonValue) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        Intrinsics.checkParameterIsNotNull((Object)bsonValue, (String)"bsonValue");
        return BsonTreeInputKt.readBson(this, bsonValue, deserializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final BsonDocument loadBsonDocument(@NotNull byte[] bytes) {
        BsonDocument bsonDocument;
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Closeable closeable = (Closeable)new ByteBufferBsonInput((ByteBuf)new ByteBufNIO(ByteBuffer.wrap(bytes)));
        boolean bl = false;
        Throwable throwable = null;
        try {
            BsonDocument bsonDocument2;
            ByteBufferBsonInput it = (ByteBufferBsonInput)closeable;
            boolean bl2 = false;
            try {
                bsonDocument2 = BsonStreamsKt.readBsonDocument((BsonInput)it);
            }
            catch (BSONException ex) {
                String string = ex.getMessage();
                if (string == null) {
                    string = "";
                }
                throw (Throwable)((Object)new BsonDecodingException(string, ex));
            }
            bsonDocument = bsonDocument2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bsonDocument;
    }

    @NotNull
    public final BsonArray loadBsonArray(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        BsonArray bsonArray = BsonValueKt.toBsonArray(this.loadBsonDocument(bytes));
        if (bsonArray == null) {
            throw (Throwable)((Object)new BsonDecodingException("Not a bson array", null, 2, null));
        }
        return bsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] dumpBson(@NotNull BsonDocument bsonDocument) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)bsonDocument, (String)"bsonDocument");
        Closeable closeable = (Closeable)new BasicOutputBuffer();
        boolean bl = false;
        Throwable throwable = null;
        try {
            BasicOutputBuffer it = (BasicOutputBuffer)closeable;
            boolean bl2 = false;
            try {
                BsonStreamsKt.writeBsonDocument((BsonOutput)it, bsonDocument);
            }
            catch (BSONException ex) {
                String string = ex.getMessage();
                if (string == null) {
                    string = "";
                }
                throw (Throwable)((Object)new BsonEncodingException(string, ex));
            }
            byte[] byArray2 = it.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"it.toByteArray()");
            byArray = byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BasicOutputBuffer().use \u2026t.toByteArray()\n        }");
        return byArray;
    }

    @NotNull
    public final byte[] dumpBson(@NotNull BsonArray bsonArray) {
        Intrinsics.checkParameterIsNotNull((Object)bsonArray, (String)"bsonArray");
        return this.dumpBson(BsonValueKt.toBsonDocument(bsonArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T> byte[] dump(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Object object;
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        BsonValue $this$fold$iv = this.toBson(serializer, value);
        Function1 unexpected$iv = BsonValueKt.fold.1.INSTANCE;
        boolean $i$f$fold = false;
        BsonType bsonType = $this$fold$iv.getBsonType();
        if (bsonType != null) {
            switch (BsonValueKt$WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
                case 1: {
                    BsonArray bsonArray = $this$fold$iv.asArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonArray, (String)"asArray()");
                    BsonArray it = bsonArray;
                    boolean bl = false;
                    object = this.dumpBson(it);
                    return (byte[])object;
                }
                case 2: {
                    BsonDocument bsonDocument = $this$fold$iv.asDocument();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bsonDocument, (String)"asDocument()");
                    BsonDocument it = bsonDocument;
                    boolean bl = false;
                    object = this.dumpBson(it);
                    return (byte[])object;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    BsonValue it = $this$fold$iv;
                    boolean bl = false;
                    throw (Throwable)((Object)new BsonEncodingException("Dumping primitives", null, 2, null));
                }
            }
        }
        object = unexpected$iv.invoke((Object)$this$fold$iv);
        return (byte[])object;
    }

    public <T> T load(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes) {
        T t;
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        BsonDocument doc = this.loadBsonDocument(bytes);
        KProperty kProperty = null;
        Lazy array2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<BsonArray>(doc){
            final /* synthetic */ BsonDocument $doc;

            @Nullable
            public final BsonArray invoke() {
                return BsonValueKt.toBsonArray(this.$doc);
            }
            {
                this.$doc = bsonDocument;
                super(0);
            }
        }));
        Function0 $fun$trialAndError$1 = new Function0<T>(this, deserializer, doc, array2, kProperty){
            final /* synthetic */ Bson this$0;
            final /* synthetic */ DeserializationStrategy $deserializer;
            final /* synthetic */ BsonDocument $doc;
            final /* synthetic */ Lazy $array;
            final /* synthetic */ KProperty $array$metadata;

            public final T invoke() {
                Object object;
                try {
                    object = this.this$0.fromBson(this.$deserializer, (BsonValue)this.$doc);
                }
                catch (BsonException docEx) {
                    Object object2;
                    try {
                        object2 = this.$array;
                        Object var4_4 = null;
                        KProperty kProperty = this.$array$metadata;
                        DeserializationStrategy deserializationStrategy = this.$deserializer;
                        Bson bson = this.this$0;
                        boolean bl = false;
                        Object object3 = object2.getValue();
                        BsonArray bsonArray = (BsonArray)object3;
                        if (bsonArray == null) {
                            throw (Throwable)((Object)new BsonDecodingException("Not a bson array", null, 2, null));
                        }
                        object2 = bson.fromBson(deserializationStrategy, (BsonValue)bsonArray);
                    }
                    catch (BsonException arrayEx) {
                        docEx.addSuppressed((Throwable)((Object)arrayEx));
                        throw (Throwable)((Object)docEx);
                    }
                    object = object2;
                }
                return object;
            }
            {
                this.this$0 = bson;
                this.$deserializer = deserializationStrategy;
                this.$doc = bsonDocument;
                this.$array = lazy;
                this.$array$metadata = kProperty;
                super(0);
            }
        };
        SerialKind serialKind = deserializer.getDescriptor().getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            Lazy lazy = array2;
            Object var9_9 = null;
            DeserializationStrategy<T> deserializationStrategy = deserializer;
            Bson bson = this;
            boolean bl = false;
            Object object = lazy.getValue();
            BsonArray bsonArray = (BsonArray)object;
            if (bsonArray == null) {
                throw (Throwable)((Object)new BsonDecodingException("Not a bson array", null, 2, null));
            }
            t = bson.fromBson(deserializationStrategy, (BsonValue)bsonArray);
        } else if (serialKind instanceof StructureKind) {
            t = this.fromBson(deserializer, (BsonValue)doc);
        } else {
            if (serialKind instanceof PrimitiveKind || Intrinsics.areEqual((Object)serialKind, (Object)UnionKind.ENUM_KIND.INSTANCE)) {
                throw (Throwable)((Object)new BsonDecodingException("Loading primitives", null, 2, null));
            }
            if (serialKind instanceof PolymorphicKind) {
                t = deserializer instanceof AbstractPolymorphicSerializer ? this.fromBson(deserializer, (BsonValue)doc) : $fun$trialAndError$1.invoke();
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)UnionKind.CONTEXTUAL.INSTANCE)) {
                t = $fun$trialAndError$1.invoke();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return t;
    }

    @NotNull
    public final BsonConfiguration getConfiguration() {
        return this.configuration;
    }

    public Bson(@NotNull BsonConfiguration configuration, @NotNull SerialModule context) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.configuration = configuration;
        this.context = SerialModuleExtensionsKt.overwriteWith((SerialModule)BsonKt.access$getDefaultBsonModule$p(), (SerialModule)context);
    }

    public /* synthetic */ Bson(BsonConfiguration bsonConfiguration, SerialModule serialModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bsonConfiguration = BsonConfiguration.Companion.getSTABLE();
        }
        if ((n & 2) != 0) {
            serialModule = (SerialModule)EmptyModule.INSTANCE;
        }
        this(bsonConfiguration, serialModule);
    }

    public Bson() {
        this(null, null, 3, null);
    }
}

