/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.encoders;

import com.github.agcom.bson.serialization.Bson;
import com.github.agcom.bson.serialization.BsonEncodingException;
import com.github.agcom.bson.serialization.encoders.AbstractBsonTreeOutput;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BsonValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/agcom/bson/serialization/encoders/BsonPrimitiveOutput;", "Lcom/github/agcom/bson/serialization/encoders/AbstractBsonTreeOutput;", "bson", "Lcom/github/agcom/bson/serialization/Bson;", "nodeConsumer", "Lkotlin/Function1;", "Lorg/bson/BsonValue;", "", "(Lcom/github/agcom/bson/serialization/Bson;Lkotlin/jvm/functions/Function1;)V", "content", "getCurrent", "putElement", "key", "", "element", "serialization"})
final class BsonPrimitiveOutput
extends AbstractBsonTreeOutput {
    private BsonValue content;

    @Override
    public void putElement(@NotNull String key, @NotNull BsonValue element) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (key != "primitive") {
            throw (Throwable)((Object)new BsonEncodingException("This output can only consume primitives with 'primitive' tag", null, 2, null));
        }
        if (this.content != null) {
            throw (Throwable)((Object)new BsonEncodingException("Primitive element was already recorded. Does call to encodeXxx happen more than once?", null, 2, null));
        }
        this.content = element;
    }

    @Override
    @NotNull
    public BsonValue getCurrent() {
        BsonValue bsonValue = this.content;
        if (bsonValue == null) {
            throw (Throwable)((Object)new BsonEncodingException("Primitive element has not been recorded. Is call to encodeXxx is missing in serializer?", null, 2, null));
        }
        return bsonValue;
    }

    public BsonPrimitiveOutput(@NotNull Bson bson, @NotNull Function1<? super BsonValue, Unit> nodeConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)bson, (String)"bson");
        Intrinsics.checkParameterIsNotNull(nodeConsumer, (String)"nodeConsumer");
        super(bson, nodeConsumer, null);
        this.pushTag("primitive");
    }
}

