/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.serializers;

import com.github.agcom.bson.serialization.serializers.DateTimeSerializer;
import com.github.agcom.bson.serialization.serializers.InstantSerializer;
import com.github.agcom.bson.serialization.serializers.LocalDateSerializer;
import com.github.agcom.bson.serialization.serializers.LocalDateTimeSerializer;
import com.github.agcom.bson.serialization.serializers.LocalTimeSerializer;
import com.github.agcom.bson.serialization.serializers.OffsetTimeSerializer;
import com.github.agcom.bson.serialization.serializers.ZonedDateTimeSerializer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.DecodingKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.EncodingKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u0019*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/github/agcom/bson/serialization/serializers/TemporalAccessorSerializer;", "T", "Ljava/time/temporal/TemporalAccessor;", "Lkotlinx/serialization/KSerializer;", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "(Lkotlinx/serialization/Decoder;)Ljava/time/temporal/TemporalAccessor;", "ofEpochMillis", "temporal", "", "(J)Ljava/time/temporal/TemporalAccessor;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "(Lkotlinx/serialization/Encoder;Ljava/time/temporal/TemporalAccessor;)V", "toEpochMillis", "(Ljava/time/temporal/TemporalAccessor;)J", "Companion", "serialization"})
public abstract class TemporalAccessorSerializer<T extends TemporalAccessor>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor = DateTimeSerializer.INSTANCE.getDescriptor();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        EncodingKt.encode((Encoder)encoder2, (SerializationStrategy)((SerializationStrategy)DateTimeSerializer.INSTANCE), (Object)this.toEpochMillis(value));
    }

    @NotNull
    public final T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        return this.ofEpochMillis(((Number)DecodingKt.decode((Decoder)decoder, (DeserializationStrategy)((DeserializationStrategy)DateTimeSerializer.INSTANCE))).longValue());
    }

    public abstract long toEpochMillis(@NotNull T var1);

    @NotNull
    public abstract T ofEpochMillis(long var1);

    @NotNull
    public T patch(@NotNull Decoder decoder, @NotNull T old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull(old, (String)"old");
        return (T)((TemporalAccessor)KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, old));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/github/agcom/bson/serialization/serializers/TemporalAccessorSerializer$Companion;", "Lcom/github/agcom/bson/serialization/serializers/TemporalAccessorSerializer;", "Ljava/time/temporal/TemporalAccessor;", "()V", "ofEpochMillis", "Ljava/time/Instant;", "temporal", "", "toEpochMillis", "serialization"})
    public static final class Companion
    extends TemporalAccessorSerializer<TemporalAccessor> {
        @Override
        public long toEpochMillis(@NotNull TemporalAccessor temporal) {
            long l;
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            TemporalAccessor temporalAccessor = temporal;
            if (temporalAccessor instanceof Instant) {
                l = InstantSerializer.INSTANCE.toEpochMillis((Instant)temporal);
            } else if (temporalAccessor instanceof LocalDateTime) {
                l = LocalDateTimeSerializer.INSTANCE.toEpochMillis((LocalDateTime)temporal);
            } else if (temporalAccessor instanceof LocalDate) {
                l = LocalDateSerializer.INSTANCE.toEpochMillis((LocalDate)temporal);
            } else if (temporalAccessor instanceof LocalTime) {
                l = LocalTimeSerializer.INSTANCE.toEpochMillis((LocalTime)temporal);
            } else if (temporalAccessor instanceof OffsetTime) {
                l = OffsetTimeSerializer.INSTANCE.toEpochMillis((OffsetTime)temporal);
            } else if (temporalAccessor instanceof ZonedDateTime) {
                l = ZonedDateTimeSerializer.INSTANCE.toEpochMillis((ZonedDateTime)temporal);
            } else {
                throw (Throwable)new IllegalArgumentException("Unsupported temporal class '" + temporal.getClass().getName() + '\'');
            }
            return l;
        }

        @Override
        @NotNull
        public Instant ofEpochMillis(long temporal) {
            Instant instant = Instant.ofEpochMilli(temporal);
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochMilli(temporal)");
            return instant;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

