/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.utils;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.StructureKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u0082\u0001\u0001\"\u00a8\u0006#"}, d2={"Lcom/github/agcom/bson/serialization/utils/MapLikeDescriptor;", "Lkotlinx/serialization/SerialDescriptor;", "serialName", "", "keyDescriptor", "valueDescriptor", "(Ljava/lang/String;Lkotlinx/serialization/SerialDescriptor;Lkotlinx/serialization/SerialDescriptor;)V", "elementsCount", "", "getElementsCount", "()I", "getKeyDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "kind", "Lkotlinx/serialization/SerialKind;", "getKind", "()Lkotlinx/serialization/SerialKind;", "getSerialName", "()Ljava/lang/String;", "getValueDescriptor", "equals", "", "other", "", "getElementAnnotations", "", "", "index", "getElementDescriptor", "getElementIndex", "name", "getElementName", "hashCode", "isElementOptional", "Lcom/github/agcom/bson/serialization/utils/NamedMapClassDescriptor;", "serialization"})
public abstract class MapLikeDescriptor
implements SerialDescriptor {
    private final int elementsCount = 2;
    @NotNull
    private final String serialName;
    @NotNull
    private final SerialDescriptor keyDescriptor;
    @NotNull
    private final SerialDescriptor valueDescriptor;

    @NotNull
    public SerialKind getKind() {
        return (SerialKind)StructureKind.MAP.INSTANCE;
    }

    public int getElementsCount() {
        return this.elementsCount;
    }

    @NotNull
    public String getElementName(int index) {
        return String.valueOf(index);
    }

    public int getElementIndex(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Integer n = StringsKt.toIntOrNull((String)name);
        if (n == null) {
            throw (Throwable)new IllegalArgumentException(name + " is not a valid map index");
        }
        return n;
    }

    public boolean isElementOptional(int index) {
        int n = index;
        if (0 > n || 1 < n) {
            throw (Throwable)new IllegalStateException("Map descriptor has only two child elements, index: " + index);
        }
        return false;
    }

    @NotNull
    public List<Annotation> getElementAnnotations(int index) {
        int n = index;
        if (0 > n || 1 < n) {
            throw (Throwable)new IndexOutOfBoundsException("Map descriptor has only two child elements, index: " + index);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public SerialDescriptor getElementDescriptor(int index) {
        SerialDescriptor serialDescriptor;
        switch (index) {
            case 0: {
                serialDescriptor = this.keyDescriptor;
                break;
            }
            case 1: {
                serialDescriptor = this.valueDescriptor;
                break;
            }
            default: {
                throw (Throwable)new IndexOutOfBoundsException("Map descriptor has only one child element, index: " + index);
            }
        }
        return serialDescriptor;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapLikeDescriptor)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getSerialName(), (Object)((MapLikeDescriptor)other).getSerialName()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.keyDescriptor, (Object)((MapLikeDescriptor)other).keyDescriptor) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.valueDescriptor, (Object)((MapLikeDescriptor)other).valueDescriptor) ^ true);
    }

    public int hashCode() {
        int result = this.getSerialName().hashCode();
        result = 31 * result + this.keyDescriptor.hashCode();
        result = 31 * result + this.valueDescriptor.hashCode();
        return result;
    }

    @NotNull
    public String getSerialName() {
        return this.serialName;
    }

    @NotNull
    public final SerialDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    @NotNull
    public final SerialDescriptor getValueDescriptor() {
        return this.valueDescriptor;
    }

    private MapLikeDescriptor(String serialName, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor) {
        this.serialName = serialName;
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
        this.elementsCount = 2;
    }

    @NotNull
    public List<Annotation> getAnnotations() {
        return SerialDescriptor.DefaultImpls.getAnnotations((SerialDescriptor)this);
    }

    public boolean isNullable() {
        return SerialDescriptor.DefaultImpls.isNullable((SerialDescriptor)this);
    }

    @NotNull
    public String getName() {
        return SerialDescriptor.DefaultImpls.getName((SerialDescriptor)this);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="annotations"), message="Deprecated in the favour of 'annotations' property")
    @NotNull
    public List<Annotation> getEntityAnnotations() {
        return SerialDescriptor.DefaultImpls.getEntityAnnotations((SerialDescriptor)this);
    }

    public /* synthetic */ MapLikeDescriptor(String serialName, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor, DefaultConstructorMarker $constructor_marker) {
        this(serialName, keyDescriptor, valueDescriptor);
    }
}

