/*
 * Decompiled with CFR 0.152.
 */
package com.github.agcom.bson.serialization.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BsonRegularExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/agcom/bson/serialization/utils/PatternUtils;", "", "()V", "GLOBAL_FLAG", "", "embeddedAsFlags", "embedded", "", "regex", "Lorg/bson/BsonRegularExpression;", "flagsAsEmbedded", "pattern", "Ljava/util/regex/Pattern;", "flags", "PatternFlag", "serialization"})
public final class PatternUtils {
    private static final int GLOBAL_FLAG = 256;
    public static final PatternUtils INSTANCE;

    @NotNull
    public final String flagsAsEmbedded(@NotNull Pattern pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        return this.flagsAsEmbedded(pattern.flags());
    }

    public final int embeddedAsFlags(@NotNull BsonRegularExpression regex) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        String string = regex.getOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"regex.options");
        return this.embeddedAsFlags(string);
    }

    @NotNull
    public final String flagsAsEmbedded(int flags) {
        int processedFlags = flags;
        StringBuilder embedded = new StringBuilder();
        for (PatternFlag flag : PatternFlag.values()) {
            if ((flags & flag.getMask()) <= 0) continue;
            embedded.append(flag.getEmbedded());
            processedFlags -= flag.getMask();
        }
        boolean bl = processedFlags <= 0;
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "some flags couldn't be recognized";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = embedded.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"embedded.toString()");
        return string;
    }

    public final int embeddedAsFlags(@NotNull String embedded) {
        Intrinsics.checkParameterIsNotNull((Object)embedded, (String)"embedded");
        CharSequence charSequence = embedded;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return 0;
        }
        int flags = 0;
        String string = embedded;
        boolean bl2 = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        int n = string3.length();
        for (int i = 0; i < n; ++i) {
            PatternFlag flag;
            char c = string3.charAt(i);
            if (PatternFlag.Companion.invoke(c) == null) {
                throw (Throwable)new IllegalArgumentException("Unrecognized flag 'c'");
            }
            flags |= flag.getMask();
        }
        return flags;
    }

    private PatternUtils() {
    }

    static {
        PatternUtils patternUtils;
        INSTANCE = patternUtils = new PatternUtils();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0010\b\u0082\u0001\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0015"}, d2={"Lcom/github/agcom/bson/serialization/utils/PatternUtils$PatternFlag;", "", "mask", "", "embedded", "", "(Ljava/lang/String;IIC)V", "getEmbedded", "()C", "getMask", "()I", "CANON_EQ", "UNIX_LINES", "GLOBAL", "CASE_INSENSITIVE", "MULTILINE", "DOTALL", "LITERAL", "UNICODE_CASE", "COMMENTS", "Companion", "serialization"})
    private static final class PatternFlag
    extends Enum<PatternFlag> {
        public static final /* enum */ PatternFlag CANON_EQ;
        public static final /* enum */ PatternFlag UNIX_LINES;
        public static final /* enum */ PatternFlag GLOBAL;
        public static final /* enum */ PatternFlag CASE_INSENSITIVE;
        public static final /* enum */ PatternFlag MULTILINE;
        public static final /* enum */ PatternFlag DOTALL;
        public static final /* enum */ PatternFlag LITERAL;
        public static final /* enum */ PatternFlag UNICODE_CASE;
        public static final /* enum */ PatternFlag COMMENTS;
        private static final /* synthetic */ PatternFlag[] $VALUES;
        private final int mask;
        private final char embedded;
        private static final Map<Character, PatternFlag> BY_EMBEDDED;
        public static final Companion Companion;

        /*
         * WARNING - void declaration
         */
        static {
            Map map;
            void $this$associateByTo$iv;
            CANON_EQ = new PatternFlag(128, 'c');
            UNIX_LINES = new PatternFlag(1, 'd');
            GLOBAL = new PatternFlag(256, 'g');
            CASE_INSENSITIVE = new PatternFlag(2, 'i');
            MULTILINE = new PatternFlag(8, 'm');
            DOTALL = new PatternFlag(32, 's');
            LITERAL = new PatternFlag(16, 't');
            UNICODE_CASE = new PatternFlag(64, 'u');
            COMMENTS = new PatternFlag(4, 'x');
            $VALUES = new PatternFlag[]{CANON_EQ, UNIX_LINES, GLOBAL, CASE_INSENSITIVE, MULTILINE, DOTALL, LITERAL, UNICODE_CASE, COMMENTS};
            Companion = new Companion(null);
            PatternFlag[] patternFlagArray = PatternFlag.values();
            Map map2 = new HashMap(PatternFlag.values().length, 1.0f);
            PatternFlag[] patternFlagArray2 = $VALUES;
            boolean $i$f$associateByTo = false;
            void var3_4 = $this$associateByTo$iv;
            int n = ((void)var3_4).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void destination$iv;
                void element$iv;
                void var7_8 = element$iv = var3_4[i];
                map = destination$iv;
                boolean bl = false;
                Character c = Character.valueOf(it.embedded);
                map.put(c, element$iv);
            }
            map = map2;
            PatternFlag[] patternFlagArray3 = patternFlagArray2;
            BY_EMBEDDED = map;
        }

        public final int getMask() {
            return this.mask;
        }

        public final char getEmbedded() {
            return this.embedded;
        }

        private PatternFlag(int mask, char embedded) {
            this.mask = mask;
            this.embedded = embedded;
        }

        public static PatternFlag[] values() {
            return (PatternFlag[])$VALUES.clone();
        }

        public static PatternFlag valueOf(String string) {
            return Enum.valueOf(PatternFlag.class, string);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/agcom/bson/serialization/utils/PatternUtils$PatternFlag$Companion;", "", "()V", "BY_EMBEDDED", "", "", "Lcom/github/agcom/bson/serialization/utils/PatternUtils$PatternFlag;", "invoke", "embedded", "serialization"})
        public static final class Companion {
            @Nullable
            public final PatternFlag invoke(char embedded) {
                return (PatternFlag)((Object)BY_EMBEDDED.get(Character.valueOf(embedded)));
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

