/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Utils {
    public static Charset UTF_8 = Charset.forName("UTF-8");

    public static String expandTabs(String str) {
        return str.replace("\t", "    ");
    }

    public static String htmlEntites(String str) {
        return str.replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String normalize(String str) {
        return Utils.expandTabs(Utils.htmlEntites(str));
    }

    public static List<String> normalize(List<String> list) {
        LinkedList<String> result = new LinkedList<String>();
        for (String line : list) {
            result.add(Utils.normalize(line));
        }
        return result;
    }

    public static List<String> wrapText(List<String> list, int columnWidth) {
        LinkedList<String> result = new LinkedList<String>();
        for (String line : list) {
            result.add(Utils.wrapText(line, columnWidth));
        }
        return result;
    }

    public static String wrapText(String line, int columnWidth) {
        int lenght = line.length();
        int delimiter = "<br>".length();
        int widthIndex = columnWidth;
        int count = 0;
        while (lenght > widthIndex) {
            line = line.subSequence(0, widthIndex + delimiter * count) + "<br>" + line.substring(widthIndex + delimiter * count);
            widthIndex += columnWidth;
            ++count;
        }
        return line;
    }

    static String join(List<String> strList, String sep) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> i = strList.iterator();
        while (i.hasNext()) {
            String s = i.next();
            builder.append(s);
            if (!i.hasNext()) continue;
            builder.append(sep);
        }
        return builder.toString();
    }
}

