/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.kodatimes;

import com.github.debop.kodatimes.KodaTimex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\bH\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/github/debop/kodatimes/TimestampZoneText;", "", "timestamp", "", "zone", "Lorg/joda/time/DateTimeZone;", "(JLorg/joda/time/DateTimeZone;)V", "zoneId", "", "(JLjava/lang/String;)V", "datetime", "Lorg/joda/time/DateTime;", "(Lorg/joda/time/DateTime;)V", "getDatetime", "()Lorg/joda/time/DateTime;", "getTimestamp", "()Ljava/lang/Long;", "timetext", "getTimetext", "()Ljava/lang/String;", "getZoneId", "toString", "koda-time"})
public class TimestampZoneText {
    @Nullable
    private final DateTime datetime;

    @Nullable
    public final Long getTimestamp() {
        DateTime dateTime = this.datetime;
        return dateTime != null ? Long.valueOf(dateTime.getMillis()) : null;
    }

    @Nullable
    public final String getZoneId() {
        DateTime dateTime = this.datetime;
        return dateTime != null && (dateTime = dateTime.getZone()) != null ? dateTime.getID() : null;
    }

    @Nullable
    public final String getTimetext() {
        DateTime dateTime = this.datetime;
        return dateTime != null ? KodaTimex.toIsoFormatHMSString(dateTime) : null;
    }

    @NotNull
    public String toString() {
        return "TimestampZoneText(timestamp=" + this.getTimestamp() + ", zoneId=" + this.getZoneId() + ", timetext=" + this.getTimetext() + ')';
    }

    @Nullable
    public final DateTime getDatetime() {
        return this.datetime;
    }

    public TimestampZoneText(@Nullable DateTime datetime) {
        this.datetime = datetime;
    }

    public TimestampZoneText(long timestamp, @NotNull DateTimeZone zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        this(new DateTime(timestamp, zone));
    }

    public TimestampZoneText(long timestamp, @NotNull String zoneId) {
        Intrinsics.checkParameterIsNotNull((Object)zoneId, (String)"zoneId");
        this(new DateTime(timestamp, DateTimeZone.forID((String)zoneId)));
    }
}

