/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.javatimes.ranges;

import com.github.debop.javatimes.JavaDateIterator;
import com.github.debop.javatimes.JavatimexKt;
import java.time.Duration;
import java.util.Date;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/debop/javatimes/ranges/DateProgressionIterator;", "Lcom/github/debop/javatimes/JavaDateIterator;", "Ljava/util/Date;", "first", "last", "step", "Ljava/time/Duration;", "(Ljava/util/Date;Ljava/util/Date;Ljava/time/Duration;)V", "finalElement", "hasNext", "", "next", "getStep", "()Ljava/time/Duration;", "stepMillis", "", "nextJavaDate", "koda-time"})
public final class DateProgressionIterator
extends JavaDateIterator<Date> {
    private final long stepMillis;
    private final Date finalElement;
    private boolean hasNext;
    private Date next;
    @NotNull
    private final Duration step;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    @NotNull
    public Date nextJavaDate() {
        Date value = this.next;
        if (Intrinsics.areEqual((Object)value, (Object)this.finalElement)) {
            if (!this.hasNext) {
                throw (Throwable)new NoSuchElementException();
            }
            this.hasNext = false;
        } else {
            this.next = JavatimexKt.plus(this.next, this.stepMillis);
        }
        return value;
    }

    @NotNull
    public final Duration getStep() {
        return this.step;
    }

    public DateProgressionIterator(@NotNull Date first, @NotNull Date last, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)last, (String)"last");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        this.step = step2;
        this.stepMillis = this.step.toMillis();
        this.finalElement = last;
        this.hasNext = this.step.compareTo(Duration.ZERO) > 0 ? first.compareTo(last) <= 0 : first.compareTo(last) >= 0;
        this.next = this.hasNext ? first : this.finalElement;
    }
}

