/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.javatimes.ranges;

import com.github.debop.javatimes.ranges.JavaInstantProgressionIterator;
import com.github.debop.javatimes.ranges.ProgressionsKt;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/github/debop/javatimes/ranges/JavaInstantProgression;", "", "Ljava/time/Instant;", "start", "endInclusive", "step", "Ljava/time/Duration;", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Duration;)V", "first", "getFirst", "()Ljava/time/Instant;", "last", "getLast", "getStep", "()Ljava/time/Duration;", "equals", "", "other", "", "hashCode", "", "isEmpty", "iterator", "", "toString", "", "Companion", "koda-time"})
public class JavaInstantProgression
implements Iterable<Instant>,
KMappedMarker {
    @NotNull
    private final Instant first;
    @NotNull
    private final Instant last;
    @NotNull
    private final Duration step;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Instant getFirst() {
        return this.first;
    }

    @NotNull
    public final Instant getLast() {
        return this.last;
    }

    @Override
    @NotNull
    public Iterator<Instant> iterator() {
        return new JavaInstantProgressionIterator(this.first, this.last, this.step);
    }

    public boolean isEmpty() {
        return this.step.compareTo(Duration.ZERO) > 0 ? this.first.compareTo(this.last) > 0 : this.first.compareTo(this.last) < 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof JavaInstantProgression && (this.isEmpty() && ((JavaInstantProgression)other).isEmpty() || Intrinsics.areEqual((Object)this.first, (Object)((JavaInstantProgression)other).first) && Intrinsics.areEqual((Object)this.last, (Object)((JavaInstantProgression)other).last) && Intrinsics.areEqual((Object)this.step, (Object)((JavaInstantProgression)other).step));
    }

    public int hashCode() {
        return this.isEmpty() ? -1 : Objects.hash(this.first, this.last, this.step);
    }

    @NotNull
    public String toString() {
        return this.step.compareTo(Duration.ZERO) > 0 ? "" + this.first + ".." + this.last + " step " + this.step : "" + this.first + " downTo " + this.last + " step " + this.step.negated();
    }

    @NotNull
    public final Duration getStep() {
        return this.step;
    }

    public JavaInstantProgression(@NotNull Instant start, @NotNull Instant endInclusive, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)endInclusive, (String)"endInclusive");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        this.step = step2;
        this.first = start;
        this.last = ProgressionsKt.getProgressionLastElement(start, endInclusive, this.step);
    }

    @JvmStatic
    @NotNull
    public static final JavaInstantProgression fromClosedRange(@NotNull Instant start, @NotNull Instant endInclusive, @NotNull Duration step2) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)endInclusive, (String)"endInclusive");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        return Companion.fromClosedRange(start, endInclusive, step2);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/github/debop/javatimes/ranges/JavaInstantProgression$Companion;", "", "()V", "fromClosedRange", "Lcom/github/debop/javatimes/ranges/JavaInstantProgression;", "start", "Ljava/time/Instant;", "endInclusive", "step", "Ljava/time/Duration;", "koda-time"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JavaInstantProgression fromClosedRange(@NotNull Instant start, @NotNull Instant endInclusive, @NotNull Duration step2) {
            Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
            Intrinsics.checkParameterIsNotNull((Object)endInclusive, (String)"endInclusive");
            Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
            return new JavaInstantProgression(start, endInclusive, step2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

