/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.javatimes.ranges;

import com.github.debop.javatimes.JavatimexKt;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a \u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a \u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"differenceModulo", "", "a", "b", "c", "", "getProgressionLastElement", "Ljava/time/Instant;", "start", "end", "step", "Ljava/time/Duration;", "Ljava/util/Date;", "mod", "koda-time"})
public final class ProgressionsKt {
    private static final int mod(int a, int b) {
        int mod = a % b;
        return mod >= 0 ? mod : mod + b;
    }

    private static final long mod(long a, long b) {
        long mod = a % b;
        return mod >= 0L ? mod : mod + b;
    }

    private static final int differenceModulo(int a, int b, int c) {
        return ProgressionsKt.mod(ProgressionsKt.mod(a, c) - ProgressionsKt.mod(b, c), c);
    }

    private static final long differenceModulo(long a, long b, long c) {
        return ProgressionsKt.mod(ProgressionsKt.mod(a, c) - ProgressionsKt.mod(b, c), c);
    }

    @NotNull
    public static final Instant getProgressionLastElement(@NotNull Instant start, @NotNull Instant end, @NotNull Duration step2) {
        Instant instant;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        if (step2.compareTo(Duration.ZERO) > 0) {
            Instant instant2 = end.minusMillis(ProgressionsKt.differenceModulo(end.toEpochMilli(), start.toEpochMilli(), step2.toMillis()));
            instant = instant2;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"end.minusMillis(differen\u2026illi(), step.toMillis()))");
        } else if (step2.compareTo(Duration.ZERO) < 0) {
            Instant instant3 = end.plusMillis(ProgressionsKt.differenceModulo(start.toEpochMilli(), end.toEpochMilli(), -step2.toMillis()));
            instant = instant3;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant3, (String)"end.plusMillis(differenc\u2026lli(), -step.toMillis()))");
        } else {
            throw (Throwable)new IllegalArgumentException("step is zero.");
        }
        return instant;
    }

    @NotNull
    public static final Date getProgressionLastElement(@NotNull Date start, @NotNull Date end, @NotNull Duration step2) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)step2, (String)"step");
        if (step2.compareTo(Duration.ZERO) > 0) {
            date = JavatimexKt.minus(end, ProgressionsKt.differenceModulo(end.getTime(), start.getTime(), step2.toMillis()));
        } else if (step2.compareTo(Duration.ZERO) < 0) {
            date = JavatimexKt.plus(end, ProgressionsKt.differenceModulo(start.getTime(), end.getTime(), -step2.toMillis()));
        } else {
            throw (Throwable)new IllegalArgumentException("step is zero.");
        }
        return date;
    }
}

